<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Models\User;
use Exception;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;

class PasswordController extends Controller
{
    /**
     * Update the user's password.
     */
    public function update(Request $request): RedirectResponse
    {
        $validated = $request->validateWithBag('updatePassword', [
            'current_password' => ['required', 'current_password'],
            'password' => ['required', Password::defaults(), 'confirmed'],
        ]);

        $request->user()->update([
            'password' => Hash::make($validated['password']),
        ]);

        return back()->with('status', 'password-updated');
    }






    public function forgetPasswordView(){
        return view('app.auth.forget_password');
    }


    public function  forgetOtpSend(Request $request){

$user=User::where('phone',$request->phone)->first();

if(!$user){
         return response()->json([
            'status' => false,
            'message' => 'User not found'
         ]);

}


         if(!$request->phone){
             return response()->json([
            'status' => false,
            'message' => 'Invalid phone number.'
        ]);
        }

        $otp = rand(100000, 999999);
        session()->put('register_otp', $otp);
        session()->put('phone', $request->phone);
        try{
         $res= sendOtpInPhoneNumber($request->phone,$otp);
         if($res['success']==true){
       return response()->json([
            'status' => true,
            'message' => 'OTP sent successfully'
         ]);
         }else{
         return response()->json([
            'status' => false,
            'message' => $res['message']
        ]);
         }



        }catch(Exception $e){
             return response()->json([
            'status' => false,
            'message' => $e->getMessage()
        ]);
        }
        

    }


    public function forgetPasswordChange(Request $request){
         $remember_otp=session()->get('register_otp');
    $rememberPhone=session()->get('phone');
    if($rememberPhone!=$request->phone){
        return back()->withErrors(['error'=>'Invalid Phone Number'])->withInput();
    }

    // Only validate session OTP - Fixed OTP removed from password reset
    if($remember_otp!=$request->otp_code){
        return back()->withErrors(['error' => 'Invalid OTP Code'])->withInput();
    }

    if(!$request->password){
         return back()->withErrors(['error'=>'Input password'])->withInput();
    }

    $user=User::where('phone',$request->phone)->first();

if(!$user){
         return back()->withErrors(['error'=>'User not found.'])->withInput();
    }


    $user->password=Hash::make($request->password);
    $user->save();

return back()->with('success','Password change successful.');
    }
}
