<?php

namespace App\Http\Controllers;

use App\Models\UserPost;
use Illuminate\Http\Request;
use App\Models\Withdrawal;

class CommunityController extends Controller
{
   public function index(){
    $user=auth()->user();
   
    $posts = UserPost::where('status',1)->latest()->get();
    $my_post=UserPost::where('user_id',$user->id)->latest()->get();
     return view('app.main.community.index',compact('user','posts','my_post'));
   }

 public function store(Request $request)
    {
        $request->validate([
            'text' => 'nullable|string|max:500',
            'image' => [
                'required',
                'mimes:jpeg,png,jpg',
                'max:2048',
               
            ],
        ]);

        $user=auth()->user();
        
   $total_withdraw= Withdrawal::where('user_id',$user->id)->where('status','approved')->count();
   $total_post=UserPost::where('user_id',$user->id)->count();
   
   if ($total_post >= $total_withdraw) {
    return back()->with("error", 'You cannot post. Please make a withdrawal first.');
}
        
        
        $path = null;
         if ($request->hasFile('image')) {
            $path = uploadImage(false, $request, 'image', 'upload/posts/', 800, 800, '');
        }

        UserPost::create([
            'user_id' => $user->id,
            'text' => $request->text,
            'image' => $path,
            'status'=>0
        ]);

         return back()->with("success", 'Post create');
    }
}
