<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Package;

class ProductController extends Controller
{
    public function showPackages()
    {
        $packages = Package::where('type', 'normal')
            ->where('status', 'active')
            ->orderBy('display_order', 'asc')
            ->get()
            ->map(function ($package) {
                $validity = (int)$package->validity;
                $package->daily_amount = $validity > 0 ? round($package->commission_with_avg_amount / $validity, 2) : 0;

                // Set rental and buy limits based on your business rules
                $package->buy_limit = $this->setBuyLimit($package);
                $package->rental_limit = $this->setRentalLimit($package);

                return $package;
            });

        return view('app.main.product', compact('packages'));
    }

    public function showComingSoon()
    {
        $packages = Package::where('type', 'coming')
            ->where('status', 'active')
            ->orderBy('display_order', 'asc')
            ->get()
            ->map(function ($package) {
                $validity = (int)$package->validity;
                $package->daily_amount = $validity > 0 ? round($package->commission_with_avg_amount / $validity, 2) : 0;

                // Set rental and buy limits
                $package->buy_limit = $this->setBuyLimit($package);
                $package->rental_limit = $this->setRentalLimit($package);

                return $package;
            });

        return view('app.main.product', compact('packages'));
    }

    public function showWelfare()
    {
        $packages = Package::where('type', 'welfare')
            ->where('status', 'active')
            ->orderBy('display_order', 'asc')
            ->get()
            ->map(function ($package) {
                $validity = (int)$package->validity;
                $package->daily_amount = $validity > 0 ? round($package->commission_with_avg_amount / $validity, 2) : 0;

                // Set rental and buy limits
                $package->buy_limit = $this->setBuyLimit($package);
                $package->rental_limit = $this->setRentalLimit($package);

                return $package;
            });

        return view('app.main.product', compact('packages'));
    }
    

    public function show($id)
    {
        $package = Package::findOrFail($id);
        $package->buy_limit = $this->setBuyLimit($package);
        $package->rental_limit = $this->setRentalLimit($package);
         $validity = (int)$package->validity;
                $package->daily_amount = $validity > 0 ? round($package->commission_with_avg_amount / $validity, 2) : 0;
        
        return view('app.main.product_detail', compact('package'));
    }

    private function setBuyLimit($package)
    {
        if (isset($package->buy_limit) && $package->buy_limit > 0) {
            return $package->buy_limit;
        }
        return $package->price > 0 ? 2 : 1; 
    }

    private function setRentalLimit($package)
    {
        return 1; 
    }
}
