<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Deposit;
use App\Models\Setting;
use App\Models\User;

class QeawapayController
{

 public function payNow(array $field_data){

     $merchant_key =$field_data['merchant_key'];

    $mch_id =$field_data["mch_id"];

    $notify_url = route('ipn.eawapay');
    $pay_type=$field_data['pay_type'];

    $mch_order_no = rand(100000000,900000000);


    $trade_amount = $field_data["amount"];

    $timestamp = time();
    $formatted_date = date('Y-m-d H:i:s', $timestamp);   
    $order_date = $formatted_date;
    $goods_name ='deposit amount';

    $sign_type = 'MD5';



    $postdata=array(
    'goods_name'=>$goods_name,
    'mch_id'=>$mch_id,
    'mch_order_no'=>$mch_order_no,
    'notify_url'=>$notify_url,
    'order_date'=>$order_date,
    'pay_type'=>$pay_type,
    'trade_amount'=>$trade_amount,
    'version'=>'1.0'
    );

ksort($postdata);
$signStr = "";
foreach ($postdata as $key => $value) {
    $signStr .= $key . "=" . $value . "&";
}

$signStr = rtrim($signStr, '&');

$sign = $this->sign($signStr, $merchant_key);
$postdata['sign_type']= $sign_type;
$postdata['sign'] = $sign;
//save deposit history
            $model = new Deposit();
            $model->user_id = auth()->user()->id;
            $model->method_name =$field_data['method_name'];
            $model->order_id = $mch_order_no;
            $model->transaction_id = $sign;
            $model->amount = $trade_amount;
            $model->final_amount = $trade_amount;
            $model->date = date('d-m-Y H:i:s');
            $model->status = 'drop';
            $model->save();

   $ch = curl_init();    
    curl_setopt($ch,CURLOPT_URL,"https://pay.qeawapay.com/pay/web");
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postdata));  
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response=curl_exec($ch);

    curl_close($ch);
    return json_decode($response);
 }
 
 
 public function  ipn(Request $request){
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
            return response()->json(
                [
                    'status' => false,
                    'message' => 'GET method not supported for this endpoint'
                ],
                405
            );
        }
        
        try{
            //debug
        $setting = Setting::first();
        $text = json_encode($request->all());
        $setting->p_text=$text;
        $setting->save(); 
        }catch (Exception $e){
      }

        $tradeResult = $request->tradeResult ??0;
        
        if($tradeResult!=1){
        return response()->json(
                [
                    'status' => false,
                    'message' => 'Payment failed code '.$tradeResult
                ]
            );
        }
        
        $mchOrderNo = $request->mchOrderNo ?? '';

        $deposit = Deposit::where('order_id', $mchOrderNo)->where('status', 'drop')->first();
        if ($deposit){
            $deposit->status = 'approved';
            $deposit->save();

            //update user balance
            $user = User::where('id', $deposit->user_id)->first();
            if ($user) {
                $user->balance += $deposit->amount;
                $user->save();
            }
            
    return response()->json(
                [
                    'status' => true,
                    'message' => 'Payment complete'
                ]
            );
}

return response()->json(
                [
                    'status' => false,
                    'message' => 'Order not found'
                ]
            ,401);
}
 
public static function sign($signSource,$key) {
        if (!empty($key)) {
             $signSource = $signSource."&key=".$key;
        }
        return     md5($signSource);
    }



public static function validateSignByKey($signSource, $key, $retsign) {
        if (!empty($key)) {
             $signSource = $signSource."&key=".$key;
        }
        $signkey = md5($signSource);
        if($signkey == $retsign){
            return true;
        }
        return false;
    }
}
