<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\UserLedger;
use App\Models\Deposit;
use App\Models\Withdrawal;
use Carbon\Carbon;

class HistoryController extends Controller
{
    public function showHistory()
    {

        $userId = auth()->id();

        $cashRecords = UserLedger::where('user_id', $userId)
            ->whereIn('reason', ['daily_income', 'commission', 'claim', 'my_commission', 'product_purchase'])
            ->orderBy('created_at', 'desc') 
            ->get()
            ->map(function ($record) {

                switch ($record->reason) {
                    case 'daily_income':
                        $record->title = 'Product Income';
                        break;
                    case 'product_purchase':
                        $record->title = 'Product Purchase';
                        break;
                    case 'commission':
                        $record->title = 'Rebate Bonus';
                        break;
                    case 'claim':
                        $record->title = 'Treasure Bonus';
                        break;
                    default:
                        $record->title = ucfirst($record->reason);
                        break;
                }
                return $record;
            });

        $rechargeRecords = Deposit::where('user_id', $userId)
            ->whereIn('status', ['pending', 'approved'])
            ->orderBy('created_at', 'desc') 
            ->get();

        // Fetch withdrawal records
        $withdrawRecords = Withdrawal::where('user_id', $userId)
            ->whereIn('status', ['pending', 'approved'])
            ->orderBy('created_at', 'desc') 
            ->get();

        // Return the view with fetched records
        return view('app.main.history', compact('cashRecords', 'rechargeRecords', 'withdrawRecords'));
    }
}
