<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Rebate;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class RebateController extends Controller
{
    public $route = 'admin.rebate';

    public function index()
    {
        // Fetch the first rebate record (id = 1) or initialize a new one
        $data = Rebate::firstOrNew(['id' => 1]);
        return view('admin.pages.rebate', compact('data'));
    }

    public function insert_or_update(Request $request)
    {
        // Validate incoming request data
        $request->validate([
            'income_commission1' => 'required|numeric',
            'income_commission2' => 'required|numeric',
            'income_commission3' => 'required|numeric',
            'interest_commission1' => 'required|numeric',
            'interest_commission2' => 'required|numeric',
            'interest_commission3' => 'required|numeric',
            'recharge_commission1' => 'required|numeric',
            'recharge_commission2' => 'required|numeric',
            'recharge_commission3' => 'required|numeric',
        ]);

        // Find or initialize rebate with id = 1
        $model = Rebate::firstOrNew(['id' => 1]);

        // Assign values from the request to the model
        $model->income_commission1 = $request->income_commission1;
        $model->income_commission2 = $request->income_commission2;
        $model->income_commission3 = $request->income_commission3;
        $model->interest_commission1 = $request->interest_commission1;
        $model->interest_commission2 = $request->interest_commission2;
        $model->interest_commission3 = $request->interest_commission3;
        $model->recharge_commission1 = $request->recharge_commission1;
        $model->recharge_commission2 = $request->recharge_commission2;
        $model->recharge_commission3 = $request->recharge_commission3;

        // Save the model (this will insert if new or update if existing)
        $model->save();

        return redirect()->route($this->route . '.index')->with('success', 'Rebate Updated Successfully.');
    }
}

