<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\Setting;
use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Str;

class SADepositGetway extends Controller
{
    protected $sendboxUrl='https://bd.api.starpago.com/';
    protected $liveUrl='https://bd.api.starpago.com/';
   public function payNow(array $field_data)
    {
        $amount=$field_data['amount'];
        $mercheantId=$field_data['appId'];
        $secrateKey=$field_data['key'];
        $type= $field_data['type'];
        $method_name= $field_data['method_name'];
        $merchantOrderNo = rand( 100000000,900000000).'2';
        $notifyUrl = route('sa.deposit.callback');

        $user=auth()->user();
        $params = [
            'appId' => $mercheantId,
            'merOrderNo' => $merchantOrderNo,
            'amount' => $amount,
            'currency' => 'BDT',
            'payMethod'=>$type,
            'notifyUrl' => $notifyUrl,
            'returnUrl'=>route('dashboard'),
            'extra'=>[
                'email'=>$user->email,
                'mobile'=>$user->phone,
                'accountName'=>$user->username,
                'accountNo'=>$user->phone
            ]
        ];


        $params['sign'] = SignGenerate::create($secrateKey,$params);

        try {
            $response = Http::post($this->liveUrl . 'api/v2/payment/order/create', $params);
           
            if ($response->successful()) {
                $data = $response->json();
               
                if (isset($data['code']) && $data['code']==0 && isset($data['data']['orderStatus']) && $data['data']['orderStatus']==1 && isset($data['data']['params']['paymentLink'])) {
                    //save deposit history
                   
                    $model = new Deposit();
                    $model->user_id = auth()->user()->id;
                    $model->method_name =$method_name;
                    $model->order_id = $data['data']['merOrderNo'];
                    $model->transaction_id = $data['data']['orderNo'];
                    $model->amount = $amount;
                    $model->final_amount = $amount;
                    $model->date = date('d-m-Y H:i:s');
                    $model->status = 'drop';
                    $model->save();
                    
                    Log::info('SA Deposit: Creating order '.json_encode($data), $params);
                    
                    // Redirect to the payment gateway
                    return redirect()->away($data['data']['params']['paymentLink']);
                } else {
                    return back()->with('error', 'Gateway Error: ' . ($data['message'] ?? 'Unknown error'));
                }
            } else {
                return back()->with('error', 'Gateway Connection Error.');
            }
        } catch (\Exception $e) {
           dd($e);
            return back()->with('error', 'An unexpected error occurred.');
        }
    }


    public function ipn(Request $request){
           if ($_SERVER['REQUEST_METHOD'] == 'GET') {
            return response()->json(
                [
                    'status' => false,
                    'message' => 'GET method not supported for this endpoint'
                ],
                405
            );
           }

       Log::info('SA Deposit: IPN Response-> ' . json_encode($request->all()));
        if(($request->orderStatus==2 || $request->orderStatus==3) && isset($request->sign)){
            $deposit=Deposit::where('order_id',$request->merOrderNo)
            ->where('status','drop')->first();

            if($deposit){
                $deposit->status = 'approved';
                $deposit->save();

                $user=User::where('id',$deposit->user_id)->first();
                if ($user) {
                    $user->balance += $deposit->amount;
                    $user->save();
                }

                return 'payment complete';
            }
            
        }

        return 'success';

    }



 public function payoutNow($field_data){
        $amount=$field_data['amount'];
        $appId=$field_data['appId'];
        $secrateKey=$field_data['key'];
        $type= $field_data['type'];
        $merchantOrderNo = rand(100000000,900000000).'2';
        $bank_account=$field_data['account'];
        $holder_name=$field_data['holderName'];

        $user=auth()->user();
        $params = [
            'appId' => $appId,
            'merOrderNo' => $merchantOrderNo,
            'amount' => $amount,
            'currency' =>'BDT',
            'payMethod'=>'BD_'.$type,
            'notifyUrl'=>route('sa.withdraw.callback'),
            'extra'=>[
                'accountNo'=>$bank_account,
                'accountName'=>$holder_name,
                'email'=>$user->email,
                'mobile'=>$user->phone
            ]
        ];

        $params['sign'] = SignGenerate::create($secrateKey,$params);


        try {
            $response = Http::post($this->liveUrl . 'api/v2/payout/order/create', $params);
           
            if ($response->successful()) {

                $data = $response->json();
                
                if (isset($data['code']) && $data['code']==0 && isset($data['msg']) && $data['msg']=='success' && isset($data['data']['orderStatus']) && ($data['data']['orderStatus']!=-1 && $data['data']['orderStatus']!=-2 && $data['data']['orderStatus']!=-3)) {
                     Log::info('SA Withdraw:'.json_encode($data), $params);
                    return [
                        'status'=>true,
                        'trx_id'=>$data['data']['merOrderNo'],
                        'message'=>'success',
                        'data'=>$data
                    ];
                } else {
                    return [
                        'status'=>false,
                        'trx_id'=>null,
                        'message'=>($data['error'] ?? 'Unknown error')
                    ];
                    
                }
            } else {
                return [
                        'status'=>false,
                        'trx_id'=>null,
                        'message'=>'Gateway Connection Error.'
                    ];
            
            }
        } catch (\Exception $e) {
            return [
                        'status'=>false,
                        'trx_id'=>null,
                        'message'=>'An unexpected error occurred.'
                    ];
            
        }
    }



    public function ipn_withdraw(Request $request){
 if ($_SERVER['REQUEST_METHOD'] == 'GET') {
            return response()->json(
                [
                    'status' => false,
                    'message' => 'GET method not supported for this endpoint'
                ],
                405
            );
           }

       Log::info('SA Withdraw: IPN Response-> ' . json_encode($request->all()));

    }

}


  class SignGenerate {

    const SIGN = 'sign';
    const KEY = 'key';
    const EXT = 'extra';

    public static function create($appSecret, $map) {
        $signStr = self::createSignStr($appSecret, $map);
        
        return hash('sha256', $signStr);
    }

    public static function createSignStr($appSecret, $map) {
        $signStr = self::joinMap($map);
        $signStr .= '&'. self::KEY . '=' . $appSecret;

        return $signStr;
    }

    private static function prepareMap($map) {
        if (!is_array($map)) {
            return array();
        }

        if (array_key_exists(self::SIGN, $map)) {
            unset($map[self::SIGN]);
        }
        ksort($map);
        reset($map);

        return $map;
    }

    private static function joinMap($map) {
        if (!is_array($map)) {
            return '';
        }

        $map = self::prepareMap($map);
        $pair = array();
        foreach($map as $key => $value) {
            if (self::isIgnoredItem($key, $value)) {
                continue;
            }

            $tmp = $key . '=';
            if(0 === strcmp(self::EXT, $key)) {
                 $tmp .= self::joinMap($value);
            } else {
                $tmp .= $value;
            }

            $pair[] = $tmp;
        }

        if (empty($pair)) {
            return '';
        }

        return join('&', $pair);
    }

    private static function isIgnoredItem($key, $value) {
        if (empty($key) || empty($value)) {
            return true;
        }

        if (0 === strcmp(self::SIGN, $key)) {
            return true;
        }

        if (0 === strcmp(self::EXT, $key)) {
            return false;
        }

        if (is_string($value)) {
            return false;
        }
        
        if (is_numeric($value)) {
            return false;
        }

        if (is_bool($value)) {
            return false;
        }
         
        return true;
    }

}
