<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\FundInvest;
use App\Models\Package;
use App\Models\Purchase;
use App\Models\Rebate;
use App\Models\User;
use App\Models\UserLedger;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;

class ComController extends Controller
{
    // ------------------ WEEKLY SALARY ------------------
    public function weeklySalary()
    {
        $admin = Admin::first();

        // Prevent duplicate salary for today
        if ($admin->weekly_salary_date == date('Y-m-d')) {
            return back()->with('error', 'Weekly salary already processed today');
        }

        $users = User::all();
        $totalPaid = 0;

        foreach ($users as $user) {
            $validInvites = User::where('ref_by', $user->ref_id)
                ->whereHas('deposits', function ($query) {
                    $query->where('status', 'approved');
                })
                ->count();

            $salary = 0;
            if ($validInvites >= 19) {
                $salary = 500;
            } elseif ($validInvites >= 6) {
                $salary = 250;
            } elseif ($validInvites >= 3) {
                $salary = 100;
            }

            if ($salary > 0) {
                $user->balance += $salary;
                $user->total_income += $salary;
                $user->team_income += $salary;
                $user->save();

                UserLedger::create([
                    'user_id' => $user->id,
                    'reason' => 'weekly_salary',
                    'amount' => $salary,
                    'credit' => $salary,
                    'debit' => 0,
                    'status' => 'approved',
                    'claimed' => true,
                    'date' => now()->format('d-m-Y H:i'),
                ]);

                $totalPaid += $salary;
            }
        }

        $admin->weekly_salary_date = date('Y-m-d');
        $admin->save();

        return back()->with('success', "Weekly Salary Processed. Total paid: ₦$totalPaid");
    }

    // ------------------ MONTHLY SALARY ------------------
    public function monthlySalary()
    {
        $admin = Admin::first();

        // Only run on the 28th
        if (date('d') != '28') {
            return back()->with('error', 'Monthly salary can only be processed on the 28th');
        }

        // Prevent duplicate
        if ($admin->monthly_salary_date == date('Y-m-d')) {
            return back()->with('error', 'Monthly salary already processed today');
        }

        $users = User::all();
        $totalPaid = 0;

        foreach ($users as $user) {
            $validInvites = User::where('ref_by', $user->ref_id)
                ->whereHas('deposits', function ($query) {
                    $query->where('status', 'approved');
                })
                ->count();

            $salary = 0;
            if ($validInvites >= 19) {
                $salary = 500;
            } elseif ($validInvites >= 6) {
                $salary = 250;
            } elseif ($validInvites >= 3) {
                $salary = 100;
            }

            if ($salary > 0) {
                $user->balance += $salary;
                $user->total_income += $salary;
                $user->team_income += $salary;
                $user->save();

                UserLedger::create([
                    'user_id' => $user->id,
                    'reason' => 'monthly_salary',
                    'amount' => $salary,
                    'credit' => $salary,
                    'debit' => 0,
                    'status' => 'approved',
                    'claimed' => true,
                    'date' => now()->format('d-m-Y H:i'),
                ]);

                $totalPaid += $salary;
            }
        }

        $admin->monthly_salary_date = date('Y-m-d');
        $admin->save();

        return back()->with('success', "Monthly Salary Processed. Total paid: ₦$totalPaid");
    }
}
