<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\UserPost;
use App\Models\UserLedger;
use Illuminate\Http\Request;
use App\Models\User;
class CommunityController extends Controller
{

  public function index($status=0){
    $posts=UserPost::where('status',$status)->latest()->paginate();
      return view('admin.pages.post.index', compact('posts'));
  }  

  public function post_view($id){
    $post=UserPost::where('id',$id)->first();
    $user=auth()->user();
     return view('admin.pages.post.view', compact('post','user'));
  }


  public function post_status($id,$status){
    if(!$id || !$status){
      return redirect()->back()->with('error','Invalid paramiter');
    }
    $post=UserPost::where('id',$id)->first();
    
    if(!$post){
          return redirect()->back()->with('error','Post not found.');
    }

    if($status==1){
        $user=User::where('id',$post->user_id)->first();
        if($user && $post->bonus_claim==0){
            $user->balance +=setting('post_bonus');
            $user->save();
            
            $post->bonus_claim=1;
            
            
            
            
        $ledger = new UserLedger();
        $ledger->user_id = $user->id;
        $ledger->reason = 'community';
        $ledger->perticulation = 'Community post bonus.';
        $ledger->amount = setting('post_bonus');
        $ledger->credit = $user->balance;
        $ledger->status = 'approved';
        $ledger->date = date("Y-m-d H:i:s");
        $ledger->save();
        
        
        }
    }

    $post->status=$status;
    $post->save();

    return redirect()->route('admin.community.index',1)->with(['success','Update success']);
  }


  public function post_delete($id){
    $post=UserPost::where('id',$id)->first();
    if(!$post){
      return redirect()->back()->with('error','Post not found.');
    }

   try {
     unlink($post->image);
   } catch (\Throwable $th) {
   }
    $post->delete();

    return redirect()->back();
  }










}
