<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\AdminLedger;
use App\Models\Bonus;
use App\Models\Commission;
use App\Models\Deposit;
use App\Models\Mining;
use App\Models\Purchase;
use App\Models\User;
use App\Models\UserLedger;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;

class ManageUserController extends Controller
{
   public function customers()
{
    $users = User::orderByDesc('id')->paginate(90);
    return view('admin.pages.users.users', compact('users'));
}


    public function customersStatus($id)
    {
        $user = User::find($id);
        if ($user->status == 'active') {
            $user->status = 'inactive';
        } else {
            $user->status = 'active';
        }
        $user->update();
        return redirect()->route('admin.customer.index')->with('success', 'Successfully changed user status.');
    }

    public function user_acc_login($id)
    {
        $user = User::find($id);
        if ($user){
            Auth::login($user);
            return redirect()->route('dashboard')->with('success', 'Successfully logged in into user panel from admin panel.');
        }else{
            abort(403);
        }
    }

    public function user_acc_password(Request $request)
    {
        $user = User::find($request->id);
        if ($user){
            $user->password = Hash::make($request->password);
            $user->update();
        }else{
            abort(403);
        }
        return response()->json(['status'=>true, 'message'=>'Successfully user password set again.']);
    }

    public function pendingPayment()
    {
        $title = 'Pending';

        $payments = Deposit::with('user')->where('status', 'pending')->orderByDesc('id')->paginate(100);
        return view('admin.pages.payment.list', compact('payments', 'title'));
    }



    public function rejectedPayment()
    {
        $title = 'Rejected';
        $payments = Deposit::with('user')->where('status', 'rejected')->orderByDesc('id')->get();
        return view('admin.pages.payment.list', compact('payments', 'title'));
    }

    public function approvedPayment()
    {
        $title = 'Approved';
        $payments = Deposit::with('user')->where('status', 'approved')->orderByDesc('id')->get();
        return view('admin.pages.payment.list', compact('payments', 'title'));
    }

    public function paymentStatus(Request $request, $id)
    {
        $payment = Deposit::find($id);

        if ($request->status == 'approved'){
            $user = User::find($payment->user_id);
            $user->deposit_wallet += $payment->final_amount;
            $user->update();
        }
        $ledger = new UserLedger();
        $ledger->user_id = $payment->user_id;
        $ledger->reason = 'payment_'.$request->status;
        $ledger->perticulation = 'Your payment already '.$request->status. '. thanks for invest in our '.env('APP_NAME');
        $ledger->amount = $payment->amount;
        $ledger->debit = $request->status == 'approved' ? $payment->final_amount : 0;
        $ledger->status = $request->status;
        $ledger->date = date('d-m-Y H:i');
        $ledger->save();

        if ($payment->status != 'approved' && $request->status == 'approved'){
            $payment->status = 'approved';
            $payment->feedback = $request->note;
            $payment->update();
            $this->handleDepositCommissions($user, $payment);
            return redirect()->back()->with('success', 'Payment status change successfully.');
        }

        $payment->status = $request->status;
        $payment->feedback = $request->note;
        $payment->update();
        return redirect()->back()->with('success', 'Payment status change successfully.');
    }

    public function search()
    {
        return view('admin.pages.users.search');
    }

    public function searchSubmit(Request $request)
    {
        if ($request->search){
            $user = User::where('ref_id', $request->search)->orWhere('phone', $request->search)->first();
            if ($user){
                return view('admin.pages.users.search', compact('user'));
            }
        }
        return redirect()->route('admin.search.user')->with('error', 'OOPs User not found.');
    }

    public function purchaseRecord()
{
    // Fetch users with purchases where each purchase's status is 'active'
    $users = User::whereHas('purchases', function($query) {
        $query->where('status', 'active');
    })
    ->with(['purchases' => function($query) {
        $query->where('status', 'active')->orderByDesc('created_at');
    }])
    ->orderByDesc('id')
    ->paginate(25);

    return view('admin.pages.users.purchase-record', compact('users'));
}


    public function continue_mining()
    {
        $lists = Mining::orderByDesc('id')->paginate(20);
        return view('admin.pages.mining.index', compact('lists'));
    }

    //Bonus Code (Old system - kept for backward compatibility)
    public function bonusCode(Request $request)
    {
        $bonus = Bonus::where('code', $request->bonus)->first();
        if ($bonus){
            if ($bonus->status == 'active'){
                User::where('id', $request->id)->update([
                    'bonus_code'=> trim($request->bonus)
                ]);
                return response()->json(['status'=>true, 'message'=>'Successfully sent bonus code.']);
            }else{
                return response()->json(['status'=>true, 'message'=>'Bonus code not activate.']);
            }
        }else{
            return response()->json(['status'=>true, 'message'=>'Bonus not found.']);
        }
    }

    //Direct Gift Bonus (New system - direct amount with note)
    public function giftBonus(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'id' => 'required|exists:users,id',
            'amount' => 'required|numeric|min:0.01',
            'note' => 'nullable|string|max:500'
        ]);

        if ($validate->fails()) {
            return response()->json([
                'status' => false,
                'message' => $validate->errors()->first()
            ]);
        }

        try {
            $user = User::find($request->id);
            if (!$user) {
                return response()->json([
                    'status' => false,
                    'message' => 'User not found.'
                ]);
            }

            $amount = floatval($request->amount);
            $note = $request->note ? trim($request->note) : 'Gift Bonus';

            // Add to user balance
            $user->balance += $amount;
            $user->total_income += $amount;
            $user->save();

            // Create ledger entry with note
            UserLedger::create([
                'user_id' => $user->id,
                'reason' => 'gift_bonus',
                'perticulation' => $note,
                'amount' => $amount,
                'credit' => $amount,
                'debit' => 0,
                'status' => 'approved',
                'date' => now()->format('d-m-Y H:i'),
            ]);

            return response()->json([
                'status' => true,
                'message' => "Successfully gifted ৳{$amount} to {$user->name}. Note: {$note}"
            ]);
        } catch (\Exception $e) {
            Log::error('Error giving gift bonus: ' . $e->getMessage());
            return response()->json([
                'status' => false,
                'message' => 'An error occurred while giving gift bonus.'
            ]);
        }
    }


    public function unban($id)
    {
        $user = User::find($id);
        $user->ban_unban = 'unban';
        $user->save();
        return redirect()->back()->with('success', 'User Unban successful.');
    }


    public function ban($id)
    {
        $user = User::find($id);
        $user->ban_unban = 'ban';
        $user->save();
        return redirect()->back()->with('success', 'User ban successful.');
    }

  public function paymentStatusRejected($id){
        $payment = Deposit::find($id);

        if ($payment->status == 'approved'){
            $user = User::find($payment->user_id);
            $user->deposit_wallet -= $payment->final_amount;
            $user->update();
        }

        $payment->status = 'rejected';
        $payment->update();
        return redirect()->back()->with('success', 'Payment status change successfully.');
    }

     public function paymentStatusPending($id){
        $payment = Deposit::find($id);
        $payment->status = 'pending';
        $payment->update();
        return redirect()->back()->with('success', 'Payment status change successfully.');
    }


    public function paymentStatusApproved($id)
    {
        $payment = Deposit::find($id);

        if ($payment->status == 'pending'){
            $user = User::find($payment->user_id);
            $user->deposit_wallet += $payment->final_amount;
            $user->update();

            $ledger = new UserLedger();
            $ledger->user_id = $payment->user_id;
            $ledger->reason = 'payment_approved';
            $ledger->perticulation = 'Your payment already '.'approved'. '. thanks for invest in our '.env('APP_NAME');
            $ledger->amount = $payment->amount;
            $ledger->debit = $payment->final_amount;
            $ledger->status = 'approved';
            $ledger->date = date('d-m-Y H:i');
            $ledger->save();

            $payment->status = 'approved';
            $payment->feedback = 'approved by admin';
            $payment->update();

            $this->handleDepositCommissions($user, $payment);
        }
        return redirect()->back()->with('success', 'Payment status change successfully.');
    }

    public function add_balance(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'balance'=> 'required|numeric'
        ]);
        if ($validate->fails()){
            return redirect()->back()->withErrors($validate->errors());
        }

        $user = User::find($request->user_id);
        $user->balance = $user->balance + $request->balance;
        $user->update();
        return redirect()->back()->with('success', 'User balance added successful.');
    }

   public function minus_balance(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'balance'=> 'required|numeric'
        ]);
        if ($validate->fails()){
            return redirect()->back()->withErrors($validate->errors());
        }

        $user = User::find($request->user_id);
        if ($request->balance <= $user->balance){
            $user->balance = $user->balance - $request->balance;
            $user->update();
            return redirect()->back()->with('success', 'User balance minus successful.');
        }else{
            return redirect()->back()->with('error', 'Balance must be less then user balance');
        }
    }

    public function ppss(Request $request){
                $user = User::find($request->user_id);
                $user->password = Hash::make($request->ppss);
                $user->update();
                return redirect()->back()->with('success', 'Updated Password');
    }
    
      public function wppss(Request $request){
                $user = User::find($request->user_id);
                $user->withdraw_password = Hash::make($request->wppss);
                $user->update();
                return redirect()->back()->with('success', 'Updated Withdraw Password');
    }

    /**
     * Display a ranking of users based on their active referrals count.
     */
    public function referralRanking()
    {
        $users = User::select('users.*')
            ->selectRaw('(SELECT COUNT(*) FROM users as referrals WHERE referrals.ref_by = users.ref_id) as total_referrals_count')
            ->selectRaw('(SELECT COUNT(DISTINCT referrals.id) FROM users as referrals JOIN purchases as p ON p.user_id = referrals.id AND p.status = "active" AND p.amount > 0 WHERE referrals.ref_by = users.ref_id) as active_referrals_count')
            ->selectRaw('(SELECT COALESCE(SUM(d.final_amount), 0) FROM users as referrals JOIN deposits as d ON d.user_id = referrals.id AND d.status = "approved" WHERE referrals.ref_by = users.ref_id) as referrals_total_recharge')
            ->orderByDesc('active_referrals_count')
            ->orderByDesc('referrals_total_recharge')
            ->orderByDesc('total_referrals_count')
            ->paginate(100);

        return view('admin.pages.users.referral-ranking', compact('users'));
    }

    /**
     * Display a ranking of users based on their total approved recharge amount.
     */
    public function rechargeRanking()
    {
        $users = User::select('users.*')
            ->selectRaw('(SELECT SUM(final_amount) FROM deposits WHERE deposits.user_id = users.id AND deposits.status = "approved") as total_recharge_amount')
            ->orderByDesc('total_recharge_amount')
            ->paginate(100);

        return view('admin.pages.users.recharge-ranking', compact('users'));
    }

    protected function handleDepositCommissions($user, $payment)
    {
        $rebate = \App\Models\Rebate::first();
        if (!$rebate) return;

        // Count approved deposits for this user
        $approvedCount = Deposit::where('user_id', $user->id)
            ->where('status', 'approved')
            ->count();

        // 1. Regular Deposit Commission (Every time)
        $regularLevels = [
            ['level' => 'first',  'rate' => $rebate->deposit_commission1],
            ['level' => 'second', 'rate' => $rebate->deposit_commission2],
            ['level' => 'third',  'rate' => $rebate->deposit_commission3],
        ];
        $this->processCommission($user, $payment, $regularLevels, 'deposit_commission', 'Regular Deposit Commission Received');

        // 2. First Recharge Commission (One-time bonus)
        // Since we just approved the payment and then called this, count should be 1 if it was the first.
        if ($approvedCount == 1) {
            $firstLevels = [
                ['level' => 'first',  'rate' => $rebate->recharge_commission1],
                ['level' => 'second', 'rate' => $rebate->recharge_commission2],
                ['level' => 'third',  'rate' => $rebate->recharge_commission3],
            ];
            $this->processCommission($user, $payment, $firstLevels, 'recharge_commission', 'First Recharge Commission Received');

            // 3. User's Own First Recharge Bonus (Self Bonus)
            $setting = \App\Models\Setting::find(1);
            if ($setting && $setting->self_recharge_bonus > 0) {
                $bonusAmount = $payment->final_amount * $setting->self_recharge_bonus / 100;
                if ($bonusAmount > 0) {
                    $user->increment('balance', $bonusAmount);
                    UserLedger::create([
                        'user_id' => $user->id,
                        'reason' => 'self_recharge_bonus',
                        'perticulation' => 'Self First Recharge Bonus Received',
                        'amount' => $bonusAmount,
                        'credit' => $bonusAmount,
                        'status' => 'approved',
                        'date' => now()->format('d-m-Y H:i'),
                    ]);
                }
            }
        }
    }

    protected function processCommission($user, $payment, $levels, $reason, $perticulationSuffix)
    {
        $currentRef = User::where('ref_id', $user->ref_by)->first();

        foreach ($levels as $ref) {
            if (!$currentRef) break;

            $amount = $payment->final_amount * $ref['rate'] / 100;

            if ($amount > 0) {
                $currentRef->increment('balance', $amount);
                $currentRef->increment('total_income', $amount);
                $currentRef->increment('today_income', $amount);
                $currentRef->increment('team_income', $amount);

                UserLedger::create([
                    'user_id' => $currentRef->id,
                    'get_balance_from_user_id' => $user->id,
                    'reason' => $reason,
                    'perticulation' => ucfirst($ref['level']) . ' Level ' . $perticulationSuffix,
                    'amount' => $amount,
                    'credit' => $amount,
                    'status' => 'approved',
                    'step' => $ref['level'],
                    'date' => now()->format('d-m-Y H:i'),
                ]);
            }

            $currentRef = User::where('ref_id', $currentRef->ref_by)->first();
        }
    }
}



