<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\SADepositGetway;
use App\Http\Controllers\WatchPayController;
use App\Models\Admin;
use App\Models\AdminLedger;
use App\Models\PaymentMethod;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\Withdrawal;
use Illuminate\Http\Request;

class ManageWithdrawController extends Controller
{
    public function pendingWithdraw()
    {
        $title = 'Pending';
        $withdraws = Withdrawal::with(['user', 'payment_method'])->where('status', 'pending')->orderByDesc('id')->get();
        return view('admin.pages.withdraw.list', compact('withdraws', 'title'));
    }

    public function processingWithdraw()
    {
        $title = 'Processing';
        $withdraws = Withdrawal::with(['user', 'payment_method'])->where('status', 'processing')->orderByDesc('id')->get();
        return view('admin.pages.withdraw.list', compact('withdraws', 'title'));
    }

    public function rejectedWithdraw()
    {
        $title = 'Rejected';
        $withdraws = Withdrawal::with(['user', 'payment_method'])->where('status', 'rejected')->orderByDesc('id')->get();
        return view('admin.pages.withdraw.list', compact('withdraws', 'title'));
    }

    public function approvedWithdraw()
    {
        $title = 'Approved';
        $withdraws = Withdrawal::with(['user', 'payment_method'])->where('status', 'approved')->orderByDesc('id')->get();
        return view('admin.pages.withdraw.list', compact('withdraws', 'title'));
    }

    /**
     * Withdraw Status Change Logic (Admin Panel Action)
     */
    public function withdrawStatus(Request $request, $id)
    {
        $withdraw = Withdrawal::find($id);
        
        if ($request->status == 'approved') {

           
            if ($request->getway_type == 'auto_wpay') {
                
                
                $method = PaymentMethod::whereIn('name', ['watchpay', 'wpay', 'WatchPay', 'WPay'])
                    ->orWhereIn('tag', ['watchpay', 'wpay', 'WatchPay', 'WPay'])
                    ->where('status', 'active')
                    ->first();
                
                if (!$method) {
                    return redirect()->back()->with('error', 'Active WatchPay Method Not Found.');
                }
                
                
                $methodName = strtolower(trim($withdraw->method_name));
                
                if (!str_contains($methodName, 'bkash') && !str_contains($methodName, 'nagad')) {
                    return redirect()->back()->with('error', 'Only Bkash Or Nagad Can Support Auto Withdraw.');
                }

                /**
         
                 * Bkash = BDT25000f012
                 * Nagad = BDT25000f999
                 */
                if (str_contains($methodName, 'bkash')) {
                    $bankCode = 'BDT25000f012'; 
                } elseif (str_contains($methodName, 'nagad')) {
                    $bankCode = 'BDT25000f999';
                } else {
                    $bankCode = $withdraw->user->gateway_method; // Fallback to DB
                }

                $payout = new WatchPayController();
                $data = [
                    'mch_id'      => $method->mch_id,
                    'secret_key'  => $method->secret_key, 
                    'amount'      => (int) $withdraw->final_amount,  
                    'bank_code'   => $bankCode, 
                    'account'     => (string) $withdraw->number,
                    'holderName'  => $withdraw->user->realname ?? 'Customer'
                ];

                
                $response = $payout->payoutNow($data);
                
                if (!$response['status']) {
                    return redirect()->back()->with('error', 'WatchPay API Error: ' . ($response['message'] ?? 'Withdraw failed'));
                }

                $withdraw->getway_info = json_encode($response);
            } 
            
            // ২. StarPego অটোমেটিক উইথড্রয়াল লজিক
            else if ($request->getway_type == 'auto_sa') {
                $method = PaymentMethod::where('tag', 'SA_StarPego')->where('status', 'active')->first();
                if (!$method) {
                    return redirect()->back()->with('error', 'Active Payment Method Not Found.');
                }
               
                $type = strtoupper(str_replace(' ', '', trim($withdraw->method_name)));
                if (!str_contains($type, 'BKASH') && !str_contains($type, 'NAGAD')) {
                    return redirect()->back()->with('error', 'Only Bkash Or Nagad Can Support Auto Withdraw.');
                }

                $payout = new SADepositGetway();
                $data = [
                    'appId' => $method->mch_id,
                    'key'   => $method->merchant_key,
                    'amount' => $withdraw->final_amount,
                    'type' => $type,
                    'account' => $withdraw->number,
                    'holderName' => $withdraw->user->realname ?? ''
                ];

                $response = $payout->payoutNow($data);
               
                if (!$response['status'] && $response['trx_id'] == null) {
                    return redirect()->back()->with('error', $response['message'] ?? 'Auto Withdraw failed');
                }

                $withdraw->getway_info = json_encode($response);
                if (isset($response['data']['data']['merOrderNo'])) {
                    $withdraw->merOrderNo = $response['data']['data']['merOrderNo'];
                }
            }

            // সাকসেস হলে লেজার আপডেট
            $withdraw->trx = '--';
            $ledger = new UserLedger();
            $ledger->user_id = $withdraw->user_id;
            $ledger->reason = 'withdraw_'.$request->status;
            $ledger->perticulation = 'Your withdraw already '.$request->status. '. thanks for withdraw in our '.env('APP_NAME');
            $ledger->amount = $withdraw->final_amount;
            $ledger->debit = $withdraw->final_amount;
            $ledger->status = $request->status;
            $ledger->date = date('d-m-Y H:i');
            $ledger->save();
        }

        // রিজেক্ট হলে ব্যালেন্স ফেরত দেওয়া
        if ($request->status == 'rejected') {
            $userRe = User::find($withdraw->user_id);
            if ($userRe) {
                $userRe->balance += $withdraw->amount;
                $userRe->update();
    
                $ledger = new UserLedger();
                $ledger->user_id = $withdraw->user_id;
                $ledger->reason = 'withdraw_'.$request->status;
                $ledger->perticulation = 'Your withdraw already '.$request->status;
                $ledger->amount = $withdraw->amount;
                $ledger->debit = $withdraw->final_amount;
                $ledger->status = $request->status;
                $ledger->date = date('d-m-Y H:i');
                $ledger->save();
            }
        }

        $withdraw->status = $request->status;
        $withdraw->admin_feedback = '----';
        $withdraw->update();
        return redirect()->back()->with('success', 'Withdraw status change successfully.');
    }
}