<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Bonus;
use App\Models\BonusLedger;
use App\Models\User;
use App\Models\UserLedger;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class SpinController extends Controller
{
    public function spin()
    {
        return view('app.main.spin.index');
    }

    public function spin_history()
    {
        return view('app.main.spin_history');
    }
//kt dev  number one dev telegram : https://t.me/kt_devloper
    public function submitbonuscheck($code)
    {
        $bonuses = Bonus::where('status', 'active')->get();  
        $user = Auth::user();
        
        if ($bonuses->isEmpty()) {
            return response()->json(['status' => false, 'message' => 'No active bonuses available.']);
        }

        foreach ($bonuses as $bonus) {
            if ($code == $bonus->code) {
                $checkBonusUses = BonusLedger::where('bonus_id', $bonus->id)
                                              ->where('user_id', $user->id)
                                              ->first();
                if ($checkBonusUses) {
                    return response()->json(['status' => false, 'message' => 'Bonus already used for this code.']);
                }

                if ($bonus->counter < $bonus->set_service_counter) {
                    return response()->json(['status' => true, 'message' => 'Bonus is available for claiming.']);
                } else {
                    return response()->json(['status' => false, 'message' => 'Bonus target reached.']);
                }
            }
        }

        return response()->json(['status' => false, 'message' => 'Code is invalid.']);
    }

    public function submitbonusamount($code)
{
    $bonuses = Bonus::where('status', 'active')->get();  
    $user = Auth::user();

    if ($bonuses->isEmpty()) {
        return response()->json(['status' => false, 'message' => 'No active bonuses available.']);
    }

    foreach ($bonuses as $bonus) {
        if ($code == $bonus->code) {
            $checkBonusUses = BonusLedger::where('bonus_id', $bonus->id)
                                          ->where('user_id', $user->id)
                                          ->first();
            if ($checkBonusUses) {
                return response()->json(['status' => false, 'message' => 'You have already claimed this bonus.']);
            }

            $amount = $bonus->amount;

            if ($bonus->counter < $bonus->set_service_counter) {
                // Increment the balance, total_income, and today_income
                User::where('id', $user->id)->update([
                    'balance' => $user->balance + $amount,
                ]);

                $user->increment('total_income', $amount);  
                $user->increment('today_income', $amount); 

                $ledger = new UserLedger();
                $ledger->user_id = $user->id;
                $ledger->reason = 'claim';
                $ledger->perticulation = 'Congratulations ' . $user->name . ' you have successfully claimed your bonus.';
                $ledger->amount = $amount;
                $ledger->credit = $amount;
                $ledger->status = 'approved';
                $ledger->date = now()->format('d-m-Y H:i');
                $ledger->save();

                Bonus::where('id', $bonus->id)->update([
                    'counter' => $bonus->counter + 1
                ]);

                $bonus_ledger = new BonusLedger();
                $bonus_ledger->user_id = $user->id;
                $bonus_ledger->bonus_id = $bonus->id;
                $bonus_ledger->bonus_code = $code;
                $bonus_ledger->amount = $amount;
                $bonus_ledger->save();

                return response()->json(['status' => true, 'message' => 'You received ' . price($amount)]);
            } else {
                return response()->json(['status' => false, 'message' => 'Bonus is no longer available.']);
            }
        }
    }

    return response()->json(['status' => false, 'message' => 'Invalid bonus code.']);
}
}