<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\UserLedger;
use App\Models\WheelHistory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class WheelController extends Controller
{
    
    private function getPrizeData()
    {
        return [
            // এই অর্ডারের সাথে আপনার blade ফাইলের চাকা আঁকার অর্ডার মিল রাখা হয়েছে
            ['number' => '0',  'color' => '#9b59b6', 'chance' => 40], // 40%
            ['number' => '15', 'color' => '#e67e22', 'chance' => 10], // 10%
            ['number' => '5',  'color' => '#2ecc71', 'chance' => 20], // 20%
            ['number' => '35', 'color' => '#3498db', 'chance' => 8],  // 8%
            ['number' => '50', 'color' => '#e74c3c', 'chance' => 7],  // 7%
            ['number' => '10', 'color' => '#f1c40f', 'chance' => 15], // 15%
        ];
    }
                                    //kt dev  number one dev telegram : https://t.me/kt_devloper
    public function showWheelPage()
    {
        return view('app.main.wheel');
    }

    
    public function getWheelStatus()
    {
        $user = Auth::user();
        $prizes = $this->getPrizeData();

        
        $prizesForFrontend = array_map(function ($prize) {
            return [
                'number' => $prize['number'],
                'color'  => $prize['color'],
            ];
        }, $prizes);

        return response()->json([
            'success' => true,
            'data'    => [
                'prizes' => $prizesForFrontend,
                'spins'  => $user->spin_count,
            ],
        ]);
    }

    
    public function submitSpin(Request $request)
    {
        $user = Auth::user();

        if ($user->spin_count <= 0) {
            return response()->json(['success' => false, 'message' => 'You do not have enough spins.'], 400);
        }

        
        $prizes = $this->getPrizeData();
        
        $randomNumber = mt_rand(1, 100);
        $cumulativeChance = 0;
        $wonPrize = null;

        foreach ($prizes as $prize) {
            $cumulativeChance += $prize['chance'];
            if ($randomNumber <= $cumulativeChance) {
                $wonPrize = $prize;
                break;
            }
        }
        
        if ($wonPrize === null) {
            $wonPrize = end($prizes);  
        }

        $wonAmount = (int)$wonPrize['number'];

        try {
            DB::beginTransaction();

            $user->decrement('spin_count');

            if ($wonAmount > 0) {
                $user->increment('balance', $wonAmount);

                UserLedger::create([
                    'user_id'       => $user->id,
                    'reason'        => 'wheel_win',
                    'perticulation' => 'Lucky Wheel prize money',
                    'amount'        => $wonAmount,
                    'credit'        => $wonAmount,
                    'status'        => 'approved',
                    'date'          => now(),
                ]);
            }

            WheelHistory::create([
                'user_id'    => $user->id,
                'amount_won' => $wonAmount,
            ]);

            DB::commit();

            return response()->json([
                'success' => true,
                'data'    => [
                    'winningPrize' => ['number' => $wonPrize['number']],
                    'spinsLeft'    => $user->spin_count,
                ],
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            // \Log::error('Wheel Spin Error: ' . $e->getMessage()); 
            return response()->json(['success' => false, 'message' => 'Something went wrong. Please try again.'], 500);
        }
    }
}

