<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Http\Services\PaymentServices;
use App\Models\PaymentMethod;
use App\Models\Purchase;
use App\Models\User;
use App\Models\Deposit; 
use App\Models\Setting;
use App\Models\UserLedger;
use App\Models\Withdrawal;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class WithdrawController extends Controller
{
    public function withdraw()
    {
        if (Auth::user()->gateway_method == null && Auth::user()->gateway_number == null) {
            return redirect()->route('user.bank');
        }
        $withdraw_charge = setting('withdraw_charge') ?? 10;
        return view('app.main.withdraw.index', compact('withdraw_charge'));
    }

    public function usdt_withdraw()
    {
        return view('app.main.withdraw.usdt');
    }

    public function withdrawRequest(Request $request, PaymentServices $payment)
    {
        $validate = Validator::make($request->all(), [
            'amount' => 'required|numeric'
        ]);
   
        $user = Auth::user();
        $todayStart = Carbon::now('Asia/Dhaka')->startOfDay();
        $todayEnd = Carbon::now('Asia/Dhaka')->endOfDay();

        $todaysWithdrawal = Withdrawal::where('user_id', $user->id)
            ->whereBetween('created_at', [$todayStart, $todayEnd])
            ->exists();

         if ($todaysWithdrawal) {
             return back()->with('error', 'You can only request a withdrawal once every 24 hours.');
         }



         $now = Carbon::now('Asia/Dhaka'); 

         // Restriction: No withdrawals on Friday and Saturday
         if ($now->isSaturday() || $now->isSunday()) {
             return back()->with('error', 'উত্তোলনের সময়: সোমবার থেকে শুক্রবার 12:00 PM -07:00 PM.');
         }

         $startTime = $now->copy()->setTime(12, 0, 0); // সকাল ১১:০০
         $endTime   = $now->copy()->setTime(19, 0, 0); // সন্ধ্যা ৬:০০
         if ($now->lt($startTime) || $now->gt($endTime)) {
             return back()->with('error', 'উত্তোলনের সময়: সোমবার থেকে শুক্রবার 12:00 PM -07:00 PM.');
         }



       

        if ($request->amount == '' || $request->amount < 1) {
            return back()->with('error', 'Withdraw Amount required.');
        }

        if (Auth::user()->gateway_method == null && Auth::user()->gateway_number == null) {
            return back()->with('success', 'Please setup your bank');
        }

       
        // $user = Auth::user();
        $setting = Setting::first();

        // $invest1 = Purchase::where('user_id', $user->id)->first();
        // if (!$invest1) {
        //     return redirect()->back()->with('error', "You need to invest before you withdraw");
        // }

        //$paymenMethod = PaymentMethod::where('tag', $setting->auto_transfer_default)->first();

        // if (!$paymenMethod) {
        //     return redirect()->back()->with('error', "You can't withdraw now, Payment method not available");
        // }

        if ($setting->open_transfer != 1) {
            return redirect()->back()->with('error', "You can't withdraw now, Service not available. Try again later.");
        }

        $status_id = 'pending';
        $status_text = 'Withdraw under review it we take within 30 minutes or less';
        $reference = rand(10000, 99999);

        $minimum_withdraw = setting('minimum_withdraw');
        $maximum_withdraw = setting('maximum_withdraw');
        $withdraw_charge = setting('withdraw_charge');

        if ($request->amount <= $user->balance) {
            if ($request->amount >= $minimum_withdraw) {
                if ($request->amount <= $maximum_withdraw) {
                    $charge = 0;
                    if ($withdraw_charge > 0) {
                        $charge = ($request->amount * $withdraw_charge) / 100;
                    }

                    $debit_wallet = debit_user_wallet($user->id, 2, 'NGN', $request->amount);

                    if ($debit_wallet['status'] == false) {
                        return redirect()->back()->with('error', $debit_wallet['message']);
                    }

                    $finalAmount = $request->amount - $charge;

                    if ($setting->auto_transfer) {
                        $transferPayment = $payment->payout($reference, "NGN", $finalAmount, $setting->auto_transfer_default, $user->gateway_method, $user->gateway_number, $user->realname);

                        if ($transferPayment['status'] == false) {
                            credit_user_wallet($user->id, 2, 'NGN', $request->amount);
                            return redirect()->back()->with("error", $transferPayment['message']);
                        }

                        // Don't set approved here; wait for webhook to approve or reject
                        $status_id = 'pending';
                        $status_text = 'Withdraw request sent. Awaiting gateway confirmation.';
                    }

                    $account_info = [
                        'bank_account' => $user->gateway_number,
                        'full_name' => $user->realname,
                        'bank_name' => $user->bank_name,
                        'bank_code' => $user->gateway_method,
                    ];

                    $withdrawal = new Withdrawal();
                    $withdrawal->user_id = $user->id;
                    $withdrawal->method_name = $user->bank_name ? $user->bank_name : '---';
                    $withdrawal->trx = $reference;
                    $withdrawal->account_info = json_encode($account_info);
                    $withdrawal->number = $user->gateway_number;
                    $withdrawal->amount = $request->amount;
                    $withdrawal->currency ='BDT';
                    $withdrawal->charge = $charge;
                    $withdrawal->oid = 'W-' . rand(100000,999999) . rand(100000,999999);
                    $withdrawal->final_amount = $finalAmount;
                    $withdrawal->status = $status_id;
                    $withdrawal->gateway_status = 'pending';
                    $withdrawal->save();

                    $ledger = new UserLedger();
                    $ledger->user_id = $user->id;
                    $ledger->reason = 'withdraw_request';
                    $ledger->perticulation = 'Your withdraw request status is pending. Awaiting confirmation.';
                    $ledger->amount = $request->amount;
                    $ledger->debit = $request->amount - $charge;
                    $ledger->status = 'pending';
                    $ledger->date = date('d-m-Y H:i');
                    $ledger->save();

                    return back()->with('success', $status_text);
                } else {
                    return back()->with('error', 'Maximum Withdraw ' . price($maximum_withdraw));
                }
            } else {
                return back()->with('error', 'Minimum Withdraw ' . price($minimum_withdraw));
            }
        } else {
            return back()->with('error', 'Your sufficient balance is low.');
        }
    }

    public function withdrawPreview()
    {
        $withdraws = Withdrawal::with('payment_method')->where('user_id', Auth::id())->orderByDesc('id')->get();
        return view('app.main.withdraw.withdraw-preview', compact('withdraws'));
    }
}
