<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    use HasFactory;

    protected $table = 'packages';

    // Define fillable fields for mass assignment
    protected $fillable = [
        'name',
        'title',
        'photo',
        'price',
        'validity',
        'commission_with_avg_amount',
        'status',
        'type',
        'is_default',
        'desc',
        'display_order',
        'capital_back',
        'created_at',
        'updated_at'
    ];

    /**
     * Accessor to get daily income by dividing commission_with_avg_amount by validity
     */
    public function getDailyIncomeAttribute()
    {
        return $this->validity > 0 ? round($this->commission_with_avg_amount / $this->validity, 2) : 0;
    }

    /**
     * Accessor to get formatted cycle as 'X days'
     */
    public function getCycleAttribute()
    {
        return "{$this->validity} days";
    }

    // Scope for active packages
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    // Scope for normal packages
    public function scopeNormal($query)
    {
        return $query->where('type', 'normal');
    }

    // Scope for coming soon packages
    public function scopeComing($query)
    {
        return $query->where('type', 'coming');
    }
}
