<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLedger extends Model
{
    use HasFactory;

    // Specify the fields that can be mass assigned
    protected $fillable = [
        'user_id',     // Allow mass assignment for user_id
        'get_balance_from_user_id', // ID of user who triggered this transaction
        'reason',      // Reason for the transaction
        'perticulation', // Detailed description/note for the transaction
        'amount',      // Total amount of the transaction
        'credit',      // Amount credited
        'debit',       // Amount debited
        'status',      // Status of the transaction
        'date',        // Date of the transaction
        'created_at',  // Timestamp of creation
        'claimed',     // claimed
        'updated_at',  // Timestamp of last update
        'step',        // Referral level (first, second, third)
    ];

    // Optionally, define the relationship with User if needed
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
