<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WheelHistory extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'spin_histories'; // টেবিলের নামটি একই থাকবে

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'amount_won',
    ];

    /**
     * Get the user that owns the spin history.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
