<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/home';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     *
     * @return void
     */
    public function boot()
    {
        // Configure rate limiting and set up routes
        $this->configureRateLimiting();

        $this->routes(function () {
            // Load API routes with "api" middleware and prefix
            Route::middleware(['api', 'throttle:api'])
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            // Load web routes with "web" middleware
            Route::middleware('web')
                ->group(base_path('routes/web.php'));
        });
    }

    /**
     * Configure the rate limiters for the application.
     *
     * @return void
     */
    protected function configureRateLimiting()
    {
        // General API rate limiting
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(1000) // Increased limit for scalability
                ->by(optional($request->user())->id ?: $request->ip());
        });

        // Specific rate limiter for "limit-check" operations
        RateLimiter::for('limit-check', function (Request $request) {
            return Limit::perMinute(800) // Adjusted rate limit
                ->by(optional($request->user())->id ?: $request->ip());
        });
    }
}
