@extends('admin.partials.master')

@section('admin_content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Job Applications</h4>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>User</th>
                                        <th>Position</th>
                                        <th>Status</th>
                                        <th>Applied At</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($applications as $app)
                                        <tr>
                                            <td>{{ $app->user->username }} ({{ $app->user->name }})</td>
                                            <td>{{ $app->position->title }}</td>
                                            <td>
                                                <span class="badge badge-light-{{ $app->status == 'approved' || $app->status == 'salary_paid' ? 'success' : ($app->status == 'pending' ? 'warning' : 'danger') }}">
                                                    {{ ucfirst(str_replace('_', ' ', $app->status)) }}
                                                </span>
                                            </td>
                                            <td>{{ $app->created_at->format('d M Y') }}</td>
                                            <td>
                                                @if($app->status == 'pending')
                                                    <a href="{{ route('admin.job.application.approve', $app->id) }}" class="btn btn-sm btn-success">Approve</a>
                                                    <a href="{{ route('admin.job.application.reject', $app->id) }}" class="btn btn-sm btn-danger">Reject</a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-2">
                            {{ $applications->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
