@extends('admin.partials.master')

@section('admin_content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Approved Jobs / Pay Salary</h4>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        
                        <!-- Search Form -->
                        <form action="{{ route('admin.job.application.approved') }}" method="GET" class="mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <input type="text" name="search" class="form-control" placeholder="Search by Username or Name..." value="{{ $search }}">
                                </div>
                                <div class="col-md-2">
                                    <button type="submit" class="btn btn-primary">Search</button>
                                </div>
                            </div>
                        </form>

                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>User</th>
                                        <th>Position</th>
                                        <th>Salary</th>
                                        <th>Last Salary Paid</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($applications as $app)
                                        <tr>
                                            <td>{{ $app->user->username }} ({{ $app->user->name }})</td>
                                            <td>{{ $app->position->title }}</td>
                                            <td>{{ price($app->position->salary) }}</td>
                                            <td>
                                                @if($app->paid_at)
                                                    <span class="text-success">{{ \Carbon\Carbon::parse($app->paid_at)->format('d M Y H:i') }}</span>
                                                @else
                                                    <span class="text-warning">Never Paid</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('admin.job.application.pay', $app->id) }}" class="btn btn-sm btn-info" onclick="return confirm('Are you sure you want to pay salary to this user?')">Pay Salary</a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">No approved applications found.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-2">
                            {{ $applications->appends(['search' => $search])->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
