@extends('admin.partials.master')

@section('admin_content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Edit Job Position</h4>
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <form action="{{ route('admin.job.update', $position->id) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                <div class="col-md-6 mb-1">
                                    <label>Title</label>
                                    <input type="text" name="title" class="form-control" value="{{ $position->title }}" required>
                                </div>
                                <div class="col-md-6 mb-1">
                                    <label>Salary</label>
                                    <input type="number" name="salary" class="form-control" value="{{ $position->salary }}" required>
                                </div>
                                <div class="col-md-6 mb-1">
                                    <label>Require Level A Referrals</label>
                                    <input type="number" name="require_l1" class="form-control" value="{{ $position->require_l1 }}">
                                </div>
                                </div>
                                <div class="col-md-6 mb-1">
                                    <label>Status</label>
                                    <select name="status" class="form-control">
                                        <option value="active" {{ $position->status == 'active' ? 'selected' : '' }}>Active</option>
                                        <option value="inactive" {{ $position->status == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-success">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
