@extends('admin.partials.master')

@section('admin_content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Job Positions</h4>
                    <a href="{{ route('admin.job.create') }}" class="btn btn-primary">Add New Position</a>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Order</th>
                                        <th>Title</th>
                                        <th>Salary</th>
                                        <th>Req. Level A</th>
                                        <th>Req. ABC</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($positions as $key => $position)
                                        <tr>
                                            <td>
                                                @if($key > 0)
                                                    <a href="{{ route('admin.job.moveUp', $position->id) }}" class="btn btn-sm btn-outline-primary" title="Move Up">
                                                        <i class="bx bx-up-arrow-alt"></i>
                                                    </a>
                                                @endif
                                                @if($key < count($positions) - 1)
                                                    <a href="{{ route('admin.job.moveDown', $position->id) }}" class="btn btn-sm btn-outline-primary" title="Move Down">
                                                        <i class="bx bx-down-arrow-alt"></i>
                                                    </a>
                                                @endif
                                            </td>
                                            <td>{{ $position->title }}</td>
                                            <td>{{ $position->salary }}</td>
                                            <td>{{ $position->require_l1 }}</td>
                                            <td>{{ $position->require_abc }}</td>
                                            <td>
                                                <span class="badge badge-light-{{ $position->status == 'active' ? 'success' : 'danger' }}">
                                                    {{ ucfirst($position->status) }}
                                                </span>
                                            </td>
                                            <td>
                                                <a href="{{ route('admin.job.edit', $position->id) }}" class="btn btn-sm btn-warning">Edit</a>
                                                <form action="{{ route('admin.job.destroy', $position->id) }}" method="POST" style="display:inline-block;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
