@extends('admin.partials.master')
@section('admin_content')
<style>
    .btn-group, .btn-group-vertical {
    position: relative;
    display: inline-flex;
    vertical-align: middle;
    display: none;
}
div#DataTables_Table_0_filter {
    display: none;
}

 
</style>
<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <div class="card-header pb-0">
                    <h4 class="card-title">
                        <div class="d-flex justify-content-between align-items-center">
                            <span>📦 Posts Lists</span>
                           
                        </div>
                    </h4>
                </div>

                <div class="card-body card-dashboard">
                    <div class="table-responsive">
                        <table class="table table-striped dataex-html5-selectors">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Photo</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($posts as $key => $row)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $row->user->name }}</td>
                                    <td>
                                        <a target="_blank" href="{{ asset(path: view_image($row->image)) }}" ><img src="{{ asset(view_image($row->image)) }}" alt="Package Photo"  class="img-thumbnail" style="height: 60px;"></a>
                                    </td>
                                    <td>
                                        @if($row->status === 1)
                                            <span class="badge badge-success">Public</span>
                                        @elseif($row->status === 0)
                                            <span class="badge badge-secondary">Pending</span>
                                        @else  
                                          <span class="badge badge-danger">Reject</span> 
                                        @endif
                                    </td>
                                    
                                    <td>
                                        
                                        <a href="{{ route('admin.community.post.view',$row->id) }}"
                                           class="btn btn-info btn-sm" data-toggle="tooltip" title="View">
                                            <i class="bx bx-show"></i>
                                        </a>

                                       


                                            <form method="get" action="{{ route('admin.community.delete', $row->id) }}" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit"
                                                    class="btn btn-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this package?')"
                                                    data-toggle="tooltip" title="Delete">
                                                    <i class="bx bx-trash"></i>
                                                </button>
                                            </form>
                                       
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div> <!-- .table-responsive -->
                </div> <!-- .card-body -->
            </div>
        </div>
    </div>

 

</section>
@endsection
