@extends('admin.partials.master')
@section('admin_content')
<style>
    .btn-group, .btn-group-vertical {
    position: relative;
    display: inline-flex;
    vertical-align: middle;
    display: none;
}
div#DataTables_Table_0_filter {
    display: none;
}
/* Post Card */
  .post-card {
    background: #fff;
    margin: 12px;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    padding: 12px;
  }

  .post-header {
    display: flex;
    align-items: center;
  }

  .profile-photo {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    background: #ccc;
    margin-right: 10px;
  }

  .user-info {
    display: flex;
    flex-direction: column;
  }

  .user-name {
    font-weight: 600;
    color: #263b8c;
  }

  .post-status {
    font-size: 13px;
    color: gray;
  }

  .post-text {
    margin: 10px 0;
    color: #333;
    word-wrap: break-word;
  }

  .post-image {
    width: 100%;
    border-radius: 10px;
    margin-top: 8px;
    max-height: 300px;
    object-fit: contain;
    background-color: #f1f1f1;
  }
 .btn_group {
    width: 100%;
    display: flex;
    justify-content: space-around;
    align-items: center;
}


.reject{
    background-color: rgb(255, 91, 27);
    padding: 5px 20px;
    margin-top: 10px;
    border-radius: 5px;
}

.approve{
    background-color: rgb(9, 255, 0);
    padding: 5px 20px;
    margin-top: 10px;
    border-radius: 5px;
}
</style>
<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <div class="card-header pb-0">
                    <h4 class="card-title">
                        <div class="d-flex justify-content-between align-items-center">
                            <span>📦 Posts View</span>
                           
                        </div>
                    </h4>
                </div>

                <div class="card-body card-dashboard">
                    <div class="table-responsive">
                         <div class="post-card">
      <div class="post-header">
        <div class="profile-photo"><img class="profile-img" style="width: 50px;" src="{{ asset('static/logo_2057191.png') }}" /> </div>
        <div class="user-info">
          <span class="user-name">{{ $post->user->name }}</span>
          <span class="post-status">{{ $post->status==1?'🌍 Public' : ($post->status==0 ? 'Pending' : 'Reject') }}</span>
        </div>
      </div>
      <div class="post-text">{{ $post->text }}</div>
      <img  src="{{ asset($post->image) }}" class="post-image" alt="Post Image">
<div class="btn_group">
        <a class="reject" href="{{ route('admin.community.post.status',[$post->id,2]) }}">Reject</a>
        <a class="approve" href="{{ route('admin.community.post.status',[$post->id,1]) }}">Approve</a>
      </div>
      
    </div>

    
                    </div> <!-- .table-responsive -->
                </div> <!-- .card-body -->
            </div>
        </div>
    </div>

 

</section>
@endsection
