@extends('admin.partials.master')
@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>Customers Invest Lists</div>
                                <div>
                                    <a href="{{ route('admin.search.user') }}" class="btn btn-success"><i class="bx bx-user"></i> Search A User</a>
                                </div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
    <div class="card-body card-dashboard">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                <tr>
                    <th>S.N</th>
                    <th>Referral ID</th>
                    <th>Phone</th>
                    <th>Invest Amount</th>
                    <th>Invest Date</th>
                    <th>Expiry Date</th>
                </tr>
                </thead>
                <tbody>
                @foreach($users as $user)
                    @foreach($user->purchases as $key => $purchase)
                        <tr>
                            <td>{{ $loop->parent->index * $users->perPage() + $key + 1 }}</td>
                            <td>{{ $user->ref_id }}</td>
                            <td>{{ $user->phone }}</td>
                            <td>{{ $purchase->amount == 0 ? 'Welfare Free Plan' : price($purchase->amount) }}</td>
                            <td>{{ $purchase->created_at->format('Y-m-d') }}</td>

                            @php
                                $validityDate = \Carbon\Carbon::parse($purchase->validity);
                                $now = \Carbon\Carbon::now();
                                $diffInDays = $validityDate->diffInDays($now);
                                $diffInMonths = $validityDate->diffInMonths($now);
                            @endphp
                            <td>
                                @if($validityDate->isFuture())
                                    @if($diffInMonths > 0)
                                        Expires in {{ $diffInMonths }} month{{ $diffInMonths > 1 ? 's' : '' }}
                                    @else
                                        Expires in {{ $diffInDays }} day{{ $diffInDays > 1 ? 's' : '' }}
                                    @endif
                                @else
                                    Expired
                                @endif
                            </td>

                        </tr>
                    @endforeach
                @endforeach
                                    </tbody>
                                </table>
                                {{ $users->links("pagination::bootstrap-4") }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
