@extends('admin.partials.master')
@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>Customers Lists</div>
                                <div>
                                    <a href="{{route('admin.search.user')}}" class="btn btn-success"><i class="bx bx-user"></i> Search A User</a>
                                </div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="mes">

                            </div>
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>Photo</th>
                                        <th>Referred by</th>
                                        <th>Referral id</th>
                                        <th>Name</th>
                                        <th>Phone</th>
                                        <th>Active VIPs</th>
                                        <th>Balance</th>
                                        <th>Status</th>
                                        <th>Ban/UnBan</th>
                                        <th>Active</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($users as $key => $row)
                                        <tr>
                                            <td>{{$key + 1}}</td>
                                            <td>
                                                <a href="{{asset($row->photo ? view_image($row->photo) : not_found_img())}}"
                                                   target="_blank">
                                                    <img width="40"
                                                         src="{{asset($row->photo ? view_image($row->photo) : not_found_img())}}"
                                                         alt="Package Photo">
                                                </a>
                                            </td>
                                            <td>{{$row->ref_by ?? 'Not Use'}}</td>
                                            <td>{{$row->ref_id}}</td>
                                            <td>{{$row->name}}</td>
                                            <td>{{$row->phone}}</td>
                                            <td>
                                                @php
                                                    $userActiveVips = \App\Models\Purchase::where('user_id', $row->id)
                                                        ->where('status', 'active')
                                                        ->with('package')
                                                        ->get()
                                                        ->pluck('package.name')
                                                        ->filter()
                                                        ->unique()
                                                        ->values();
                                                @endphp
                                                @if($userActiveVips->count() > 0)
                                                    @foreach($userActiveVips as $vipName)
                                                        <div class="badge badge-secondary">{{ $vipName }}</div>
                                                    @endforeach
                                                @else
                                                    <span class="text-muted">No Active VIPs</span>
                                                @endif
                                            </td>
                                            <td>{{number_format($row->balance, 2)}}</td>
                                            <td>{{$row->status}}</td>
                                            <td>
                                                @if($row->ban_unban == 'unban')
                                                    <a href="{{route('admin.user.ban', $row->id)}}"
                                                       class="btn btn-danger"
                                                       style="padding: 3px 7px;font-size: 20px" title='Account Ban'>
                                                        <i class="bx bx-user-minus"></i></a>
                                                        <span style="color: green">UnBan <i class="bx bx-check"></i> </span>
                                                @else
                                                    <a href="{{route('admin.user.unban', $row->id)}}"
                                                       class="btn btn-success"
                                                       style="padding: 3px 7px;font-size: 20px"
                                                       title='Account UnBan'>
                                                        <i class="bx bx-user-plus"></i></a>
                                                        <span style="color: red">Ban <i class="bx bx-closet"></i> </span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="javascript:void(0)"
                                                   class="btn btn-danger"
                                                   style="padding: 3px 7px;font-size: 20px"
                                                   data-target="#bonusModal{{$row->id}}"
                                                   data-toggle="modal" title='Bonus Gift'>
                                                    <i class="bx bx-gift"></i></a>

                                                <a href="{{route('admin.customer.login', $row->id)}}"
                                                   target="_blank"
                                                   class="btn btn-info"
                                                   style="padding: 3px 7px;font-size: 20px"
                                                   data-toggle="tooltip" title='Login Into User Account'>
                                                    <i class="bx bx-user"></i></a>

                                                <a href="javascript:void(0)"
                                                   class="btn btn-primary"
                                                   data-target="#myModal{{$row->id}}"
                                                   style="padding: 3px 7px;font-size: 20px"
                                                   data-toggle="modal" title='Change Password'>
                                                    <i class="bx bx-lock"></i></a>

                                                <a href="{{route('admin.customer.status', $row->id)}}"
                                                   class="btn @if($row->status == 'active') btn-success @else btn-danger @endif"
                                                   style="padding: 3px 7px;font-size: 20px"
                                                   data-toggle="tooltip"
                                                   title='@if($row->status == 'active') User status inactive after click @else User status active after click @endif'>
                                                    <i class="bx @if($row->status == 'active') bx-up-arrow @else bx-down-arrow @endif"></i></a>
                                            </td>
                                        </tr>

                                        <form action="javascript:void(0)" method="POST">@csrf
                                            <div class="modal fade" id="myModal{{$row->id}}">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">

                                                        <!-- Modal Header -->
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">Set New Password</h4>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        </div>

                                                        <!-- Modal body -->
                                                        <div class="modal-body">
                                                            <div class="form-group">
                                                                <label for="password">Password </label>
                                                                <input name="password" id="password" class="form-control is-valid" placeholder="Set User Password Again">
                                                            </div>
                                                        </div>

                                                        <!-- Modal footer -->
                                                        <div class="modal-footer">
                                                            <input type="submit" value="Submit" onclick="resetPassword('{{$row->id}}')" class="btn btn-primary">
                                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </form>


                                        <form action="javascript:void(0)" method="POST">@csrf
                                            <div class="modal fade" id="bonusModal{{$row->id}}">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">

                                                        <!-- Modal Header -->
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">Gift Bonus</h4>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        </div>

                                                        <!-- Modal body -->
                                                        <div class="modal-body">
                                                            <div class="form-group">
                                                                <label for="giftAmount{{$row->id}}">Amount <span class="text-danger">*</span></label>
                                                                <input type="number" step="0.01" min="0.01" name="amount" id="giftAmount{{$row->id}}" required class="form-control is-valid" placeholder="Enter bonus amount">
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="giftNote{{$row->id}}">Note (Reason for bonus)</label>
                                                                <textarea name="note" id="giftNote{{$row->id}}" class="form-control" rows="3" placeholder="e.g., Welcome bonus, Referral reward, Special promotion, etc."></textarea>
                                                                <small class="form-text text-muted">This note will appear in user's account history</small>
                                                            </div>
                                                        </div>

                                                        <!-- Modal footer -->
                                                        <div class="modal-footer">
                                                            <input type="submit" value="Give Bonus" onclick="submitGiftBonus('{{$row->id}}')" class="btn btn-primary">
                                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    @endforeach
                                </table>
                                {{$users->links("pagination::bootstrap-4")}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <script>
        function submitGiftBonus(id)
        {
            var amount = document.getElementById('giftAmount'+id).value;
            var note = document.getElementById('giftNote'+id).value;
            
            if(!amount || parseFloat(amount) <= 0) {
                document.querySelector('.mes').innerHTML = `<div class="alert alert-danger">Please enter a valid amount</div>`
                return;
            }
            
            var data = {
                id: id,
                amount: amount,
                note: note || 'Gift Bonus'
            }
            fetch('{{route('admin.customer.gift.bonus')}}',
                {
                    method:"POST",
                    body:JSON.stringify(data),
                    headers: {'Content-type': 'application/json; charset=UTF-8', 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')}})
                .then(response => response.json())
                .then(data => {
                    if (data.status === true){
                        document.querySelector('.mes').innerHTML = `<div class="alert alert-success">${data.message}</div>`
                        $('#bonusModal'+id).modal('hide');
                        $('.modal-backdrop').remove();
                        setTimeout(() => {
                            window.location.reload();
                        }, 1500);
                    }else {
                        document.querySelector('.mes').innerHTML = `<div class="alert alert-danger">${data.message || 'Something went wrong'}</div>`
                    }
                }).catch(error => {
                    console.error('Error:', error);
                    document.querySelector('.mes').innerHTML = `<div class="alert alert-danger">An error occurred. Please try again.</div>`
                });
        }
    </script>


    <script>
        function resetPassword(id)
        {
            var password = document.querySelector('input[name="password"]').value;
            var data = {
                id: id,
                password: password
            }
            fetch('{{route('admin.customer.change-password')}}',
                {
                    method:"POST",
                    body:JSON.stringify(data),
                    headers: {'Content-type': 'application/json; charset=UTF-8', 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')}})
                .then(response => response.json())
                .then(data => {
                    if (data.status === true){
                        document.querySelector('.mes').innerHTML = `<div class="alert alert-success">${data.message}</div>`
                        window.location.reload();
                    }else {
                        document.querySelector('.mes').innerHTML = `<div class="alert alert-success">Something went wrong</div>`
                    }
                });
        }
    </script>
@endsection





