@extends('admin.partials.master')
@include('admin.partials.message')
@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">


                <div class="card">
                    <div class="card-header pb-0">

                        @if(session()->has('error'))
                <p style="width: 100%; color: white; background-color: #fb3838; padding: 10px; border-radius: 10px;">{{ session()->get('error') }}</p>
                @endif
               
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>{{$title}} Withdraw Lists</div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>User Info</th>
                                        <th>Withdraw Info</th>
                                        <th>Amount Amounts</th>
                                        <th>Status</th>
                                        <th>Active</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($withdraws as $key => $row)
                                        <tr>
                                            <td>{{$key + 1}}</td>
                                            <td>
                                                <small>
                                                    Username: {{$row->user->username ?? '--'}}  <br>
                                                    Ref id: {{$row->user->ref_id ?? '--'}} <br>
                                                </small>
                                            </td>
                                            <td>
                                                <small>
                                                    Withdraw Method: {{$row->method_name ? $row->method_name : '---'}} <br>
                                                    Account Name: {{ optional($row->user)->realname ?? '--' }} <br>
                                                    Withdraw Number: {{$row->number}} <br>
                                                    Order Number : {{$row->oid ? $row->oid : '---'}} <br>
                                                </small>
                                            </td>
                                            <td>
                                                <small>
                                                    Withdraw Amount: {{price($row->amount)}} <br>
                                                    Withdraw Charge: {{price($row->charge)}} <br>
                                                    Return Amount : {{price($row->final_amount)}}
                                                </small>
                                            </td>
                                            <td>
                                                <small>
                                                    Status: <span class="badge @if($row->status == 'pending') badge-warning @elseif($row->status == 'approved') badge-success  @elseif($row->status == 'rejected') badge-danger @endif" style="font-size: 8px">{{$row->status}}</span> <br>
                                                </small>
                                            </td>
                                            <td>
                                                @if($row->status == 'pending')
                                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#myModal{{$row->id}}" class="btn btn-success">Action</a>
                                                    
                                          <!-- Cloudpay (Gcash) Button -->
@if($row->method_name == 'Gcash')
    <form action="https://forexxtrading.vip/public/api/payout/withdrawal.php" method="POST" style="display:inline;">
        @csrf
        <input type="hidden" name="name" value="{{$row->user->name}}">
        <input type="hidden" name="number" value="{{$row->number}}">
        <input type="hidden" name="oid" value="{{$row->oid}}">
        <input type="hidden" name="converted_amount" value="{{ price($row->final_amount ) }}">
        <button type="submit" class="btn" style="background-color: #1e6cdf; color: white;">C-Pay(Gcash)</button>
    </form>
@elseif($row->method_name == 'Paymaya')
    <!-- Paymaya Button -->
    <form action="https://forexxtrading.vip/public/api1/payout/paymaya/withdrawal.php" method="POST" style="display:inline;">
        @csrf
        <input type="hidden" name="name" value="{{$row->user->name}}">
        <input type="hidden" name="number" value="{{$row->number}}">
        <input type="hidden" name="oid" value="{{$row->oid}}">
        <input type="hidden" name="converted_amount" value="{{ price($row->final_amount ) }}">
        <button type="submit" class="btn" style="background-color: #fb389d; color: white;">C-Pay(Paymaya)</button>
    </form>
@endif


                                                    <form action="{{route('withdraw.status.change', $row->id)}}" method="POST">@csrf
                                                        <div class="modal fade" id="myModal{{$row->id}}">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">

                                                                    <!-- Modal Header -->
                                                                    <div class="modal-header">
                                                                        <h4 class="modal-title">Action for withdraw</h4>
                                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                    </div>

                                                                    <!-- Modal body -->
                                                                    <div class="modal-body">
                                                                        <div class="form-group">
                                                                            <label for="status">Status <small class="text-info"> You can change withdraw status link approved, rejected, pending is default </small> </label>
                                                                            <select name="status" required id="status" class="form-control">
                                                                                <option value="approved" @if($row->status == 'approved') selected @endif>Approved</option>
                                                                                <option value="rejected" @if($row->status == 'rejected') selected @endif>Rejected</option>
                                                                                <!--<option value="processing" @if($row->status == 'processing') selected @endif>Processing sent onepay</option>-->
                                                                            </select>
                                                                        </div>


                                                                        <div class="form-group">
                                                                            <label for="status">Getway <small class="text-info">Getway Type  automatic only Bkash/Nagad suppoted</small> </label>
                                                                            <select name="getway_type" required id="status" class="form-control">
                                                                                <option value="auto_wpay">Automatic-Wpay</option>
                                                                                <option value="auto_sa">Automatic-SA-Starpago</option>
                                                                                <option value="menual">Menual</option>
                                                                                <!--<option value="processing" @if($row->status == 'processing') selected @endif>Processing sent onepay</option>-->
                                                                            </select>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Modal footer -->
                                                                    <div class="modal-footer">
                                                                        <input type="submit" value="Submit" class="btn btn-primary">
                                                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                @else
                                                    <div class="text-info">Already push an action</div>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
