@extends('admin.partials.master')

@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">Edit Service Link</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <form action="{{ route('admin.service.update', $service->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="form-group">
                                    <label for="name">Service Name</label>
                                    <input type="text" class="form-control" value="{{ $service->name }}" disabled>
                                </div>

                                <div class="form-group">
                                    <label for="platform">Platform</label>
                                    <input type="text" class="form-control" value="{{ ucfirst($service->platform) }}" disabled>
                                </div>

                                <div class="form-group">
                                    <label for="link">Service Link</label>
                                    <input type="url" class="form-control" name="link" value="{{ $service->link }}" required>
                                </div>

                                <button type="submit" class="btn btn-primary">Update Link</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
