<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Register</title>
  <link rel="icon" type="image/png" href="/static/img/images.png">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css" />
  <style>
    :root {
      --primary: #004831;
      --primary-dark: #004831;
      --gray: #888;
      --white: #fff;
    }

    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: var(--primary);
      color: var(--gray);
    }

    .container {
      max-width: 420px;
      margin: 40px auto;
      background-color: var(--white);
      border-radius: 32px 32px 0 0;
      padding: 24px;
    }

    .logo {
      text-align: center;
      margin-top: -20px;
    }

    .logo img {
      height: 60px;
      margin-bottom: 10px;
    }

    .tab-switch {
      display: flex;
      justify-content: space-around;
      border-radius: 32px 32px 0 0;
      background: var(--primary-dark);
    }

    .tab-switch div {
      flex: 1;
      text-align: center;
      padding: 14px 0;
      font-weight: bold;
      color: white;
      cursor: pointer;
      border-bottom: 3px solid transparent;
    }

    .tab-switch .active {
      background-color: var(--white);
      color: var(--primary);
      border-bottom: 3px solid var(--primary);
      border-radius: 32px 32px 0 0;
    }

    .form-title {
      text-align: center;
      font-size: 22px;
      font-weight: bold;
      color: var(--primary);
      margin: 20px 0;
    }

    .input-group {
      margin-bottom: 18px;
      position: relative;
    }

    .input-label {
      font-size: 14px;
      margin-bottom: 6px;
      display: block;
      color: #555;
    }

    .layui-input {
      width: 100%;
      height: 42px;
      border-radius: 12px;
      padding: 0 12px;
    }

    .phone-group {
      display: flex;
    }

    .phone-code {
      padding: 0 5px;
      background-color: #f2f2f2;
      border-radius: 12px 0 0 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      color: var(--primary);
      font-weight: bold;
      border: 1px solid #ddd;
    }

    .phone-input {
      flex: 1;
      border-radius: 0 12px 12px 0;
      border-left: none;
    }

    .captcha-group {
      display: flex;
    }

    .captcha-input {
      flex: 1;
      border-radius: 12px 0 0 12px;
    }

    .captcha-img {
      width: 100px;
      height: 42px;
      background-color: #f0f0f0;
      border: 1px solid var(--primary);
      border-left: none;
      border-radius: 0 12px 12px 0;
      cursor: pointer;
      background-size: cover;
      background-repeat: no-repeat;
      background-position: center;
    }

    .submit-btn {
      background-color: var(--primary);
      color: white;
      width: 100%;
      padding: 12px;
      border: none; 
      border-radius: 50px;
      font-weight: bold;
      margin-top: 12px;
      font-size: 16px;
      cursor: pointer;
      transition: background 0.2s ease;
    }

    .submit-btn:hover {
      background-color: var(--primary-dark);
    }

    .show-password {
      position: absolute;
      right: 12px;
      top: 34px;
      cursor: pointer;
      font-size: 16px;
      color: #aaa;
    }

    .error-text {
      color: red;
      font-size: 13px;
      margin-bottom: 8px;
    }
    
    .layui-input:focus {
      border-color: var(--primary) !important;
  }
  </style>
</head>
<body>

  <div class="container">
    <div class="logo">
      <img src="https://aicash365.com/static/img/aicash222.png" alt="Logo" />
    </div>

   

    <div class="form-title">Forget password</div>

    <form id="registerForm" class="layui-form" method="post" action="{{ route('user.forget.password_change') }}">
      @csrf
      @include('alert-message')

      <div id="signup_layout">
        <div class="input-group">
        <label class="input-label">Mobile phone number</label>
        <div class="phone-group">
          <div class="phone-code">+88</div>
          <input type="tel" name="phone" id="phone" placeholder="Please enter your phone" class="layui-input phone-input" required />
        </div>
      </div>


      <button id="send_otp_btn" type="button" class="submit-btn">Send OTP</button>
    
      </div>

      <div id="otp_layout" style="display: none;">
       
        <div class="input-group">
        <label class="input-label">New Password</label>
        
         <input type="password" name="password" id="passwordInput" placeholder="enter new password" class="layui-input" required />
      </div>


      <div class="input-group">
        <label class="input-label">Verification code?</label>
        <input type="text"  class="layui-input" placeholder="Enter 6 digit code" name="otp_code" />
        <small style="color: green; padding-left: 10px;">Otp send successful.</small>
      </div>

      <button type="button" id="verification_btn" class="submit-btn">Submit</button>
      </div>
    
      </form>


    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/layui.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>

    $('#send_otp_btn').on('click',function(){
        
      if($('#phone').val().length==0){
     const Toast = Swal.mixin({
    toast: true,
    position: 'center',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true
  }     );
      Toast.fire({
          icon: 'error',
          title: 'Invalid Phone Number.'
        });

        return;
      }



   //send otp   
Swal.fire({
    title: 'Submitting...',
    text: 'Please wait while we process your request',
    allowOutsideClick: false,
    didOpen: () => {
      Swal.showLoading();
    }
  });

  $.ajax({
        url: "{{ route('user.forget.send.otp') }}",
        type: "POST",
        data: {
            _token: "{{ csrf_token() }}",
            phone: $("#phone").val()
        },
        success: function(res) {
               
            if(res.status){
                $('#signup_layout').hide();
                $("#otp_layout").show();
                Swal.fire({
      icon: 'success',
      title: 'Success!',
      text: res.message
    });
            
            }else{
                Swal.fire({
      icon: 'error',
      title: 'Error!',
      text: res.message
    });
            }

        },
        error: function(err) {
            console.error(err);
             Swal.fire({
      icon: 'error',
      title: 'Error!',
      text: 'Something went wrong'
    });
          
        }
    });

    });



    $('#verification_btn').on('click',function(){
      $('#registerForm').submit();
    });


    function togglePassword() {
      const input = document.getElementById('passwordInput');
      input.type = input.type === 'password' ? 'text' : 'password';
    }

  </script>
</body>
</html>
