<!DOCTYPE html>
<html lang="en">
<head>
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-T3XGKYQQNJ"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-T3XGKYQQNJ');
</script>
  
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Register</title>
  <link rel="icon" type="image/png" href="/static/img/images.png">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css" />
  <!-- Global Color Scheme -->
  <link rel="stylesheet" href="{{asset('public/assets/global-colors.css')}}">
  <style>
    :root {
      --primary: #004831;
      --primary-dark: #003d28;
      --button: #A0C81E;
      --gray: #888;
      --white: #fff;
    }

    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: var(--primary);
      color: var(--gray);
    }

    .container {
      max-width: 420px;
      margin: 40px auto;
      background-color: var(--white);
      border-radius: 32px 32px 0 0;
      padding: 24px;
    }

    .logo {
      text-align: center;
      margin-top: -20px;
    }

    .logo img {
      height: 60px;
      margin-bottom: 10px;
    }

    .tab-switch {
      display: flex;
      justify-content: space-around;
      border-radius: 32px 32px 0 0;
      background: var(--primary-dark);
    }

    .tab-switch div {
      flex: 1;
      text-align: center;
      padding: 14px 0;
      font-weight: bold;
      color: white;
      cursor: pointer;
      border-bottom: 3px solid transparent;
    }

    .tab-switch .active {
      background-color: var(--white);
      color: #004831 !important;
      border-bottom: 3px solid var(--primary);
      border-radius: 32px 32px 0 0;
    }

    .form-title {
      text-align: center;
      font-size: 22px;
      font-weight: bold;
      color: #004831;
      margin: 20px 0;
    }

    .input-group {
      margin-bottom: 18px;
      position: relative;
    }

    .input-label {
      font-size: 14px;
      margin-bottom: 6px;
      display: block;
      color: #004831;
    }

    .layui-input {
      width: 100%;
      height: 42px;
      border-radius: 12px;
      padding: 0 12px;
    }

    .phone-group {
      display: flex;
    }

    .phone-code {
      padding: 0 5px;
      background-color: #f2f2f2;
      border-radius: 12px 0 0 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #004831 !important;
      font-weight: bold;
      border: 1px solid #ddd;
    }

    .phone-input {
      flex: 1;
      border-radius: 0 12px 12px 0;
      border-left: none;
    }

    .captcha-group {
      display: flex;
    }

    .captcha-input {
      flex: 1;
      border-radius: 12px 0 0 12px;
    }

    .captcha-img {
      width: 100px;
      height: 42px;
      background-color: #f0f0f0;
      border: 1px solid var(--primary);
      border-left: none;
      border-radius: 0 12px 12px 0;
      cursor: pointer;
      background-size: cover;
      background-repeat: no-repeat;
      background-position: center;
    }

    .submit-btn {
      background-color: var(--button);
      color: #000000;
      width: 100%;
      padding: 12px;
      border: none; 
      border-radius: 50px;
      font-weight: bold;
      margin-top: 12px;
      font-size: 16px;
      cursor: pointer;
      transition: background 0.2s ease;
    }

    .submit-btn:hover {
      background-color: #8fb01a;
    }

    .show-password {
      position: absolute;
      right: 12px;
      top: 34px;
      cursor: pointer;
      font-size: 16px;
      color: #aaa;
    }

    .error-text {
      color: red;
      font-size: 13px;
      margin-bottom: 8px;
    }
    
    .layui-input:focus {
      border-color: var(--primary) !important;
  }
  </style>
</head>
<body>

  <div class="container">
    <div class="logo">
      <img src="static/img/aicash222.png" alt="Logo" />
    </div>

    <div class="tab-switch">
      <div class="active" onclick="switchTab('register')">Register</div>
      <div onclick="location.href='/login'">Login</div>
    </div>

    <div class="form-title">Register</div>

    <form id="registerForm" class="layui-form" method="post" action="{{ url('register') }}">
      @csrf
      @include('alert-message')

      <!-- Phone Number -->
      <div class="input-group">
        <label class="input-label">Mobile phone number</label>
        <div class="phone-group">
          <div class="phone-code">+88</div>
          <input type="tel" name="phone" id="phone" placeholder="Please enter your phone" class="layui-input phone-input" required />
        </div>
      </div>

      <!-- OTP Field with Send Button -->
      <div class="input-group">
        <label class="input-label">OTP Code</label>
        <div style="display: flex; align-items: center; border: 1px solid #ddd; border-radius: 12px; overflow: hidden;">
          <input type="text" name="otp_code" id="otp_code" placeholder="Please enter OTP Code" style="flex: 1; border: none; padding: 12px; outline: none; font-size: 14px;" />
          <button id="send_otp_btn" type="button" style="background: none; border: none; color: #00bcd4; padding: 12px 16px; cursor: pointer; font-weight: 600; font-size: 15px; white-space: nowrap;">Send OTP</button>
        </div>
        <!-- Hidden field to store admin OTP in background -->
        <input type="hidden" id="admin_otp_hidden" value="" />
        <small style="color: green; padding-left: 10px; display: none;" id="otp_success_msg">✓ OTP sent successfully!</small>
        <small style="color: #666; padding-left: 10px; display: none;" id="otp_countdown_msg"></small>
      </div>

      <!-- Password -->
      <div class="input-group">
        <label class="input-label">Password</label>
        <input type="password" name="password" id="passwordInput" placeholder="Please enter password" class="layui-input" required />
        <span class="show-password" onclick="togglePassword()">👁️</span>
      </div>

      <!-- Invitation Code -->
      <div class="input-group">
        <label class="input-label">Invitation Code</label>
        <input type="text" name="ref_by" value="{{isset($ref_by) && !empty($ref_by) && $ref_by != null ? $ref_by : ''}}" class="layui-input" placeholder="Enter invitation code" required />
      </div>

      <!-- Captcha (Hidden) -->
      <div class="input-group" style="display: none;">
        <label class="input-label">Verification Code</label>
        <div class="captcha-group">
          <input type="text" name="captcha" placeholder="Enter code" class="layui-input captcha-input" value="" />
          <div class="captcha-img" onclick="refreshCaptcha()" id="captchaBox"
               style="background-image: url('{{ captcha_src('custom') }}');"></div>
        </div>
      </div>

      <!-- Register Button -->
      <button id="register_btn" type="button" class="submit-btn">Register Now</button>
    
      </form>


    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/layui.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
    let countdownTimer = null;
    let countdownSeconds = 0;

    // Check for admin OTP on page load
    $(document).ready(function() {
      @if(isset($adminOtp) && $adminOtp)
        // Store admin OTP in hidden field (NOT visible to user)
        $('#admin_otp_hidden').val('{{ $adminOtp }}');
        // DO NOT show the OTP or any message to user
      @endif
    });

    function startCountdown(seconds) {
      countdownSeconds = seconds;
      $('#send_otp_btn').prop('disabled', true);
      $('#otp_countdown_msg').show();
      
      countdownTimer = setInterval(function() {
        countdownSeconds--;
        const minutes = Math.floor(countdownSeconds / 60);
        const secs = countdownSeconds % 60;
        $('#otp_countdown_msg').text(`Please wait ${minutes}:${secs.toString().padStart(2, '0')} before resending`);
        
        if (countdownSeconds <= 0) {
          clearInterval(countdownTimer);
          $('#send_otp_btn').prop('disabled', false);
          $('#send_otp_btn').text('Resend OTP').css('color', '#00bcd4');
          $('#otp_countdown_msg').hide();
        }
      }, 1000);
    }

    // Send OTP Button Click
    $('#send_otp_btn').on('click', function(){
      if($(this).prop('disabled')) {
        return;
      }

      if($('#phone').val().length == 0){
        const Toast = Swal.mixin({
          toast: true,
          position: 'center',
          showConfirmButton: false,
          timer: 3000,
          timerProgressBar: true
        });
        Toast.fire({
          icon: 'error',
          title: 'Invalid Phone Number.'
        });
        return;
      }

      // Send OTP
      Swal.fire({
        title: 'Sending OTP...',
        text: 'Please wait',
        allowOutsideClick: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });

      $.ajax({
        url: "{{ route('user.signup.send.otp') }}",
        type: "POST",
        data: {
          _token: "{{ csrf_token() }}",
          phone: $("#phone").val()
        },
        success: function(res) {
          if(res.status){
            // Clear admin OTP since user requested their own OTP
            $('#admin_otp_hidden').val('');
            
            // Show success message
            $('#otp_success_msg').show();
            $('#send_otp_btn').text('Resend').css('color', '#22c55e');
            
            // Start 90 second countdown
            startCountdown(90);
            
            Swal.fire({
              icon: 'success',
              title: 'Success!',
              text: res.message
            });
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Error!',
              text: res.message
            });
          }
        },
        error: function(err) {
          console.error(err);
          Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'Something went wrong'
          });
        }
      });
    });

    // Register Button Click
    $('#register_btn').on('click', function(){
      // If OTP field is empty, check if admin OTP is available
      if($('#otp_code').val().trim() === '') {
        const adminOtp = $('#admin_otp_hidden').val();
        if(adminOtp) {
          // Use admin OTP silently (in background)
          $('#otp_code').val(adminOtp);
        }
      }
      $('#registerForm').submit();
    });


    function refreshCaptcha() {
      const box = document.getElementById('captchaBox');
      const newUrl = "{{ captcha_src('custom') }}?t=" + Date.now();
      box.style.backgroundImage = `url('${newUrl}')`;
    }

    function togglePassword() {
      const input = document.getElementById('passwordInput');
      input.type = input.type === 'password' ? 'text' : 'password';
    }

    function switchTab(tab) {
      // Tab switch logic if needed
    }
  </script>
</body>
</html>
