<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>About</title>
    <link rel="icon" type="image/png" href="/static/img/images.png">
    <link rel="stylesheet" href="/static/reset.css?v={{ time() }}"/>
    <link rel="stylesheet" href="/static/style.css?v={{ time() }}"/>
    <link rel="stylesheet" href="/static/layui.css?v={{ time() }}"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css" />
    <style>
        body {
            background-color: #ffffff !important; /* Clean white background */
            color: #000;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding-bottom: 80px; /* Space for bottom nav */
        }
        .vip-container {
            padding: 15px;
            max-width: 800px;
            margin: 0 auto;
            background-color: #ffffff;
        }
        .vip-header {
            text-align: center;
            margin-bottom: 25px;
            margin-top: 20px;
        }
        .vip-header h3 {
            color: #1a1a1a;
            font-weight: 700;
            border-bottom: 3px solid #28a745;
            display: inline-block;
            padding-bottom: 8px;
            font-size: 22px;
            letter-spacing: 0.5px;
        }
        .vip-table {
            width: 100%
;
            border-collapse: collapse;
            margin-bottom: 25px;
            font-size: 11px;
            text-align: center;
            background-color: #fff;
            color: #000;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .vip-table th {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: #ffffff;
            padding: 12px 4px;
            font-weight: 600;
            border: none;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 10px;
        }
        .vip-table td {
            padding: 10px 4px;
            border: 1px solid #e0e0e0;
            color: #333;
            font-weight: 500;
        }
        .vip-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .vip-table tr:hover {
            background-color: #e8f5e9;
            transition: background-color 0.3s ease;
        }
        
        .info-box {
            background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
            color: #000;
            padding: 18px;
            border-radius: 12px;
            margin-bottom: 25px;
            border-left: 4px solid #28a745;
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
        }
        .info-box strong {
            color: #28a745;
            font-size: 15px;
        }
        .info-box ul {
            padding-left: 20px;
            margin: 10px 0 0 0;
        }
        .info-box li {
            margin-bottom: 8px;
            font-size: 13px;
            color: #444;
            line-height: 1.6;
        }
        
        .section-title {
            color: #1a1a1a;
            font-size: 17px;
            font-weight: 700;
            margin-top: 25px;
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            padding-bottom: 8px;
            border-bottom: 2px solid #e0e0e0;
        }
        .section-title::before {
            content: '♦';
            color: #28a745;
            margin-right: 8px;
            font-size: 20px;
        }

        .level-list {
            font-size: 13px;
            line-height: 1.8;
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
        }
        .level-item {
            color: #28a745;
            font-weight: 700;
            font-size: 14px;
        }
        .level-desc {
            color: #555;
        }

        .tips-title {
            color: #dc3545;
            font-weight: 700;
            margin-top: 25px;
            margin-bottom: 12px;
            font-size: 16px;
        }
        .tips-text {
            font-size: 13px;
            color: #444;
            line-height: 1.7;
            background-color: #fff3cd;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #ffc107;
        }

        .reward-table {
            width: 100%;
            margin-top: 15px;
            border-collapse: collapse;
            color: #000;
            text-align: center;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border-radius: 8px;
            overflow: hidden;
        }
        .reward-table th, .reward-table td {
            border: 1px solid #e0e0e0;
            padding: 12px;
        }
        .reward-table th {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: #ffffff;
            font-weight: 600;
        }
        .reward-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .reward-table tr:hover {
            background-color: #e8f5e9;
        }
        
        .highlight-green {
            color: #28a745;
            font-weight: 700;
            margin-top: 20px;
            font-size: 14px;
            background-color: #d4edda;
            padding: 12px;
            border-radius: 8px;
            border-left: 4px solid #28a745;
        }

        /* Top Bar */
        .top-bar {
            background: linear-gradient(135deg, #004831, #003d28); /* IDG Capital Green */
            padding: 16px;
            color: #fff;
            display: flex;
            align-items: center;
            justify-content: center; /* Center the title */
            position: relative;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .top-bar .back-btn {
            color: white;
            font-size: 20px;
            position: absolute; /* Absolute position to not affect centering */
            left: 16px;
            text-decoration: none;
            transition: opacity 0.3s;
        }
        .top-bar .back-btn:hover {
            opacity: 0.8;
        }
        .top-bar .title {
            font-size: 18px;
            font-weight: 700;
            letter-spacing: 0.5px;
        }
        
        /* Additional styling for better readability */
        p {
            color: #444;
            line-height: 1.6;
        }
        
        h3 {
            color: #1a1a1a;
        }
    </style>
</head>
<body>

    <div class="top-bar">
        <a href="javascript:history.back()" class="back-btn">
            <i class="layui-icon layui-icon-left"></i> Back
        </a>
        <div class="title">About</div>
    </div>

    <div class="vip-container">


        <p style="font-size: 16px; color: #000; line-height: 1.6;">
            <span class="highlight">AI Cash</span> is a forward-looking investment company focused exclusively on artificial intelligence and AI-driven innovation.
        </p>
<br>
        <p style="font-size: 16px; color: #000; line-height: 1.6;">
            Artificial intelligence is transforming every major industry—how businesses operate, how decisions are made, and how value is created. At AI Cash, we recognize AI as one of the most powerful and enduring forces shaping the global economy. Our purpose is to identify and invest in AI-related products, companies, and technologies that are defining this new era.
        </p>
<br>
        <h2>Who We Are</h2>
        <p style="font-size: 16px; color: #000; line-height: 1.6;">
            AI Cash was founded with a clear belief: specialization creates advantage. Rather than spreading capital across unrelated sectors, we concentrate entirely on artificial intelligence. This focused strategy allows us to develop deep expertise, stronger insights, and a clearer understanding of the opportunities and risks within the AI ecosystem.
        </p>

        <p style="font-size: 16px; color: #000; line-height: 1.6;">
            We operate as long-term investors, seeking sustainable growth rather than short-term speculation. Our decisions are guided by research, data, and a strong conviction in the transformative power of intelligent technologies.
        </p>
<br>
        <h2>Our Investment Focus</h2>
        <p style="font-size: 16px; color: #000; line-height: 1.6;"> AI Cash invests across the full spectrum of AI innovation, including but not limited to:</p>
        <ul style="font-size: 16px; color: #000; line-height: 1.6; ">
            <li>• AI software, platforms, and infrastructure</li>
            <li>• Machine learning, deep learning, and data intelligence</li>
            <li>• AI-powered products and consumer applications</li>
            <li>• Automation, robotics, and intelligent systems</li>
            <li>• Industry-specific AI solutions in finance, healthcare, manufacturing, agriculture, education, logistics, and technology</li>
        </ul>
<br>
        <h2>Our Philosophy</h2>
        <p style="font-size: 16px; color: #000; line-height: 1.6;">
            We believe successful AI investing requires more than enthusiasm for technology. It requires discipline, patience, and a clear understanding of how innovation translates into economic value.
        </p>

        <ul style="font-size: 16px; color: #000; line-height: 1.6;">
            <li><strong>• Focus:</strong> Investing only in AI-related opportunities</li>
            <li><strong>• Research:</strong> Deep analysis of technology, markets, and execution</li>
            <li><strong>• Long-term Vision:</strong> Supporting growth as AI adoption expands</li>
        </ul>
<br>
        <h2>Our Vision</h2>
        <p style="font-size: 16px; color: #000; line-height: 1.6;">
            AI Cash envisions a future where artificial intelligence empowers people, businesses, and societies to operate more intelligently and efficiently. By investing in AI today, we aim to participate in building that future while delivering meaningful value to our investors.
        </p>
<br>
        <h2>Our Commitment</h2>
        <p style="font-size: 16px; color: #000; line-height: 1.6;">
            We are committed to transparency, responsible investing, and continuous learning as AI technology evolves. As the AI landscape grows more complex, AI Cash remains dedicated to staying informed, adaptive, and focused on long-term success.
        </p>
<br>

        
        <p class="highlight-green">
             AI Cash — Investing Where Intelligence Creates Value.
        </p>
        
<br>        
        <!-- Main Content Section -->
        <main class="p-4 md:p-8 space-y-8">
            <!-- Image 2 -->
            <div class="text-center">
                <img src="/static/aboutus.png" alt="about 3" class="w-full rounded-lg shadow-md">
            </div>

        </main>
    </div>

    </div>

    @include('app.layout.manu')

</body>
</html>
