<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Check In</title>
    <link rel="icon" type="image/png" href="/static/img/images.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-dark-start: #1a202c;
            --bg-dark-end: #2d3748;
            --container-bg: rgba(23, 25, 35, 0.6);
            --border-color: rgba(255, 255, 255, 0.1);
            --glow-color: #00e5ff;
            --gold-color: #FFD700;
            --text-light: #edf2f7;
            --text-muted: #a0aec0;
            --claimed-bg: #3c4a5f;
            --unavailable-bg: rgba(10, 10, 20, 0.6);
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, var(--bg-dark-start), var(--bg-dark-end));
            background-size: 200% 200%;
            animation: moveGradient 15s ease infinite;
            margin: 0;
            padding: 20px;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            color: var(--text-light);
            box-sizing: border-box;
        }

        @keyframes moveGradient {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        .container {
            position: relative;
            background: var(--container-bg);
            border: 1px solid var(--border-color);
            border-radius: 20px;
            padding: 60px 30px 40px;
            width: 100%;
            max-width: 600px;
            text-align: center;
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.37), inset 0 0 10px rgba(0,0,0,0.5);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }

        .title-banner {
            font-size: 2.5em;
            font-weight: 700;
            color: white;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 10px;
            text-shadow: 0 0 10px var(--glow-color), 0 0 20px var(--glow-color), 0 0 30px var(--glow-color);
        }

        .countdown {
            margin-bottom: 30px;
            font-size: 1.1em;
            color: var(--text-muted);
        }

        #checkInButtons {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(80px, 1fr));
            gap: 15px;
        }

        .button {
            background: linear-gradient(145deg, #4a5568, #2d3748);
            border: 2px solid transparent;
            border-radius: 12px;
            color: var(--text-light);
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
            padding: 15px 5px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100px;
            font-weight: 600;
            overflow: hidden;
        }

        .button:hover:not(:disabled) {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        }

        /* Claimable button style */
        .button:not(.disabled):not(.unavailable) {
            border-color: var(--glow-color);
            box-shadow: 0 0 15px var(--glow-color);
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { box-shadow: 0 0 15px var(--glow-color); }
            50% { box-shadow: 0 0 25px var(--glow-color); }
            100% { box-shadow: 0 0 15px var(--glow-color); }
        }
        
        /* 7th day special reward */
        .button.special-reward:not(.disabled):not(.unavailable) {
            border-color: var(--gold-color);
            box-shadow: 0 0 20px var(--gold-color);
            animation: pulse-gold 2s infinite;
        }

        @keyframes pulse-gold {
            0% { box-shadow: 0 0 15px var(--gold-color); }
            50% { box-shadow: 0 0 25px var(--gold-color); }
            100% { box-shadow: 0 0 15px var(--gold-color); }
        }

        .button.disabled {
            background: var(--claimed-bg);
            cursor: default;
        }
        
        .button.disabled::after {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(0, 0, 0, 0.4);
            z-index: 1;
        }

        .button.unavailable {
            background: var(--unavailable-bg);
            color: var(--text-muted);
            cursor: not-allowed;
            opacity: 0.7;
        }

        .button div {
            line-height: 1.3;
        }
        
        .reward-item {
            font-size: 1.1em;
            color: var(--gold-color);
            font-weight: 700;
            margin-top: 5px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 5px;
        }

        .reward-icon {
            width: 1.2em;
            height: 1.2em;
        }

        .button.disabled .reward-item {
            color: #b09946;
        }

        .button span { /* The checkmark */
            font-size: 2.2em;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            text-shadow: 0 0 15px rgba(127, 255, 0, 0.9);
            z-index: 2;
        }
        
        .button.disabled > div {
            opacity: 0.5;
        }

        @media (max-width: 600px) {
            body { padding: 10px; }
            .container { padding: 50px 20px 30px; }
            .title-banner { font-size: 2em; }
            .countdown { font-size: 1em; }
            #checkInButtons { gap: 10px; }
            .button { min-height: 90px; }
        }

    </style>
</head>
<body>
    <div class="container">
        <div class="title-banner">DAILY REWARD</div>
        <div class="countdown" id="countdownTimer"></div>
        <div id="checkInButtons">
            @php
                use Carbon\Carbon;
                $today = Carbon::today();
                $registered = \Carbon\Carbon::parse(auth()->user()->created_at)->startOfDay();
                $daysSinceRegister = $registered->diffInDays($today);
                $startOfUserWeek = $registered->copy()->addDays(floor($daysSinceRegister / 7) * 7);
                $todayIndex = $today->diffInDays($startOfUserWeek); // 0–6
            @endphp

            @for ($day = 0; $day < 7; $day++)
                @php
                    $claimed = isset($claimedDays[$day]);
                    $isAvailable = ($day === $todayIndex);
                    $rewardAmount = $rewards[$day];
                @endphp
                <button class="button {{ $claimed ? 'disabled' : (!$isAvailable ? 'unavailable' : '') }} {{ $day === 6 ? 'special-reward' : '' }}"
                        onclick="{{ !$claimed && $isAvailable ? "checkIn(" . ($day + 1) . ")" : '' }}"
                        {{ $claimed || !$isAvailable ? 'disabled' : '' }}>
                    <div>Day {{ $day + 1 }}</div>
                    <div class="reward-item">
                        <svg class="reward-icon" viewBox="0 0 24 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-1-10h2v-2h-2v2zm0 4h2v-2h-2v2z"/></svg>
                        ৳{{ $rewardAmount }}
                    </div>
                    @if ($claimed)
                        <span>✅</span>
                    @endif
                </button>
            @endfor
        </div>
    </div>
    @include('alert-message')
    @include('alert-message') {{-- Optional Blade component for flash messages --}}

    <script>
        function checkIn(day) {
            fetch('/check-in', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({ day: day })
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(err => {
                        throw new Error(err.message || 'Something went wrong');
                    });
                }
                return response.json();
            })
            .then(data => {
                alert(data.message);
                location.reload();
            })
            .catch(error => {
                alert('Error: ' + error.message);
            });
        }

        // Countdown timer to midnight
        function updateCountdown() {
            const now = new Date();
            const midnight = new Date();
            midnight.setHours(24, 0, 0, 0);
            const diff = midnight - now;

            if (diff <= 0) {
                document.getElementById('countdownTimer').textContent = "New check-in available soon...";
                return;
            }

            const hours = Math.floor(diff / (1000 * 60 * 60));
            const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((diff % (1000 * 60)) / 1000);

            document.getElementById('countdownTimer').textContent =
                `Next check-in in: ${hours.toString().padStart(2, '0')}h ${minutes.toString().padStart(2, '0')}m ${seconds.toString().padStart(2, '0')}s`;
        }

        setInterval(updateCountdown, 1000);
        updateCountdown();
    </script>
</body>
</html>

