
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Community</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/glightbox/dist/css/glightbox.min.css" />
<script src="https://cdn.jsdelivr.net/gh/mcstudios/glightbox/dist/js/glightbox.min.js"></script>
<style>
  * {
    box-sizing: border-box;
  }

  body {
    margin: 0;
    font-family: "Poppins", sans-serif;
    background: #f3f6fb;
    overflow-x: hidden;
  }

  /* Top Bar */
  .topbar {
    background: #004831;
    color: #fff;
    text-align: center;
    padding: 10px;
    font-size: 18px;
    font-weight: 600;
  }

  /* Tabs */
  .tabs {
    display: flex;
    background: #004831;
    justify-content: center;
  }

  .tab {
    flex: 1;
    text-align: center;
    padding: 10px;
    cursor: pointer;
    color: #ffffff;
    font-weight: 500;
    transition: 0.3s;
    background: rgba(255, 255, 255, 0.1);
  }

  /* Public Tab - Green when active */
  #publicTab.active {
    background: #A0C81E;
    color: #000000;
    border-top-left-radius: 8px;
    border-top-right-radius: 8px;
    font-weight: 600;
  }

  /* My Post Tab - Orange when active */
  #myPostTab.active {
    background: #A0C81E;
    color: #000000;
    border-top-left-radius: 8px;
    border-top-right-radius: 8px;
    font-weight: 600;
  }

  /* Hover effects */
  #publicTab:hover:not(.active) {
    background: rgba(0, 72, 49, 0.3);
  }

  #myPostTab:hover:not(.active) {
    background: rgba(0, 72, 49, 0.3);
  }

  /* Scrollable Content */
  .content {
    height: calc(100vh - 120px);
    overflow-y: auto;
    padding-bottom: 100px;
  }

  /* Post Card */
  .post-card {
    background: #fff;
    margin: 12px;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    padding: 12px;
  }

  .post-header {
    display: flex;
    align-items: center;
  }

  .profile-photo {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    background: #ccc;
    margin-right: 10px;
  }

  .user-info {
    display: flex;
    flex-direction: column;
  }

  .user-name {
    font-weight: 600;
    color: #004831;
  }

  .post-status {
    font-size: 13px;
    color: gray;
  }

  .post-text {
    margin: 10px 0;
    color: #333;
    word-wrap: break-word;
  }

  .post-image {
    width: 100%;
    border-radius: 10px;
    margin-top: 8px;
    max-height: 300px;
    object-fit: contain;
    background-color: #f1f1f1;
  }

  /* Floating Button */
  .fab {
    position: fixed;
    bottom: 80px;
    right: 20px;
    background: #A0C81E;
    color: #000000;
    border: none;
    border-radius: 50%;
    width: 60px;
    height: 60px;
    font-size: 30px;
    cursor: pointer;
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
    transition: 0.3s;
    z-index: 20000;
  }

  .fab:hover {
    background: #8fb01a;
    transform: scale(1.1);
  }

  /* Bottom Dialog */
  .bottom-dialog {
    position: fixed;
    left: 0;
    bottom: -100%;
    width: 100%;
    background: #fff;
    border-top-left-radius: 20px;
    border-top-right-radius: 20px;
    box-shadow: 0 -4px 20px rgba(0,0,0,0.3);
    transition: bottom 0.4s ease;
    padding: 20px;
    z-index: 30000;
  }

  .bottom-dialog.active {
    bottom: 0;
  }

  .dialog-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #004831;
    font-weight: 600;
  }

  .form-group {
    margin-top: 15px;
  }

  .form-group textarea {
    width: 100%;
    border: 1px solid #ccc;
    border-radius: 10px;
    padding: 10px;
    resize: none;
    font-size: 15px;
  }

  .form-group input[type="file"] {
    width: 100%;
    margin-top: 10px;
  }

  .dialog-buttons {
    display: flex;
    justify-content: space-between;
    margin-top: 15px;
    gap: 10px;
  }

  .submit-btn, .cancel-btn {
    flex: 1;
    border: none;
    border-radius: 10px;
    padding: 12px;
    font-size: 16px;
    cursor: pointer;
  }

  .submit-btn {
    background: #A0C81E;
    color: #000000;
  }

  .submit-btn:hover {
    background: #8fb01a;
  }

  .cancel-btn {
    background: #ddd;
    color: #000;
  }

  .cancel-btn:hover {
    background: #ccc;
  }


  .footer_menu {
    position: fixed;
    z-index: 9999;
    bottom: 0;
    left: 0;
    right: 0;
    border-radius: 120px 120px 0 0;
    margin: 0;
    padding: 0;
    height: 65px;
}

img.profile-img {
    width: 50px;
    height: 50px;
}
</style>
</head>
<body>

  <div class="topbar" style="display: flex; align-items: center; justify-content: center;"><a style="color: white; position: absolute; left: 15px;" href="javascript:history.back()" class="back-btn">←</a>  <p style="margin: 0;">Community</p></div>

  <div class="tabs">
    <div class="tab active" id="publicTab">Public</div>
    <div class="tab" id="myPostTab">My Post</div>
  </div>

  <!-- Scrollable Content -->
  <div id="publicpost">
  <div class="content" id="postContainer">
    @foreach ($posts as $post)
      <div class="post-card">
      <div class="post-header">
        <div class="profile-photo"><img class="profile-img" src="{{ asset('static/airounds.png') }}" /> </div>
        <div class="user-info">
          <span class="user-name">ID: {{ $post->user->ref_id }}</span>
          <span style="font-size: 12px;" class="create_at"> {{ \Carbon\Carbon::parse($post->created_at)->diffForHumans() }} </span>
          <span class="post-status">🌍 Public</span>
        </div>
      </div>
      <div class="post-text">{{ $post->text }}</div>
      <a href="{{ asset($post->image) }}" class="glightbox" ><img src="{{ asset($post->image) }}" class="post-image" alt="Post Image"></a>
      
    </div>
    @endforeach
  </div>
  </div>

  <div style="display: none" id="privatepost">
<div class="content" id="postContainer">
    @foreach ($my_post as $post)
      <div class="post-card">
      <div class="post-header">
        <div class="profile-photo"><img class="profile-img" src="{{ asset('static/logo_2057191.png') }}" /> </div>
        <div class="user-info">
          <span class="user-name">ID: {{ $post->user->ref_id }}</span>
          <span class="post-status" style="color : {{ $post->status==1 ? 'gray' : '#F44336' }}">{{ $post->status==0 ? '🌍 Pending' : ($post->status==1 ? '🌍 Public' : '🌍 Reject') }}</span>
        </div>
      </div>
      <div class="post-text">{{ $post->text }}</div>
      <img src="{{ asset($post->image) }}" class="post-image" alt="Post Image">
    </div>
    @endforeach
  </div>
  </div>

  
  <button class="fab" id="openDialog">+</button>

  
  <div class="bottom-dialog" id="bottomDialog">
    <div class="dialog-header">
      <span>Create Post</span>
    </div>
    <form id="post_form" action="{{ route('community.store') }}" method="post" enctype="multipart/form-data">
      @csrf
      <div class="form-group">
      <textarea id="postText" name="text" rows="3" placeholder="What's on your mind?"></textarea>
      <input name="image" type="file" id="postImage" accept="image/*">
      <div class="dialog-buttons">
        <button class="cancel-btn" id="cancelDialog">Cancel</button>
        <button class="submit-btn" id="submitPost">Post</button>
      </div>
    </div>
    </form>
  </div>
@include('alert-message')
  @include('app.layout.manu')
  
  <script type="text/javascript">
  const lightbox = GLightbox({
                         selector: '.glightbox'
                          });
</script>
<script>
  const openBtn = document.getElementById("openDialog");
  const cancelBtn = document.getElementById("cancelDialog");
  const dialog = document.getElementById("bottomDialog");
  const postContainer = document.getElementById("postContainer");
  const postText = document.getElementById("postText");
  const postImage = document.getElementById("postImage");
  const submitPost = document.getElementById("submitPost");
  const postForm=document.getElementById('post_form');
  const publicpost =document.getElementById('publicpost');
  const privatepost=document.getElementById('privatepost');

  openBtn.onclick = () => dialog.classList.add("active");
  cancelBtn.onclick = () => dialog.classList.remove("active");

  submitPost.onclick = () => {
    const text = postText.value.trim();
    const file = postImage.files[0];
    if (!text && !file) {
      alert("Please write something or add an image!");
      return;
    }

    document.querySelector('.loadingClass').style.display = 'block';
     post_form.submit();   
  };

  // Tabs Switch
  document.getElementById("publicTab").onclick = function() {
    this.classList.add("active");
    document.getElementById("myPostTab").classList.remove("active");
    privatepost.style.display='none';
    publicpost.style.display='block';

  };

  document.getElementById("myPostTab").onclick = function() {
    this.classList.add("active");
    document.getElementById("publicTab").classList.remove("active");
    privatepost.style.display='block';
    publicpost.style.display='none';
  };
</script>



<div class="loadingClass" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); color: white; text-align: center; padding-top: 20%; font-size: 20px; z-index: 9999;">
        Wait...
    </div>

    <style>
        #snackbar-success, #snackbar-error {
            visibility: hidden;
            min-width: 250px;
            margin-left: -125px;
            background-color: #333; 
            color: #fff; 
            text-align: center;
            border-radius: 4px;
            padding: 16px;
            position: fixed;
            z-index: 9999;
            left: 50%;
            top: 50%; 
            transform: translate(-50%, -50%); 
            font-size: 17px;
        }

        #snackbar-success.show, #snackbar-error.show {
            visibility: visible;
            -webkit-animation: fadein 0.5s, fadeout 0.5s 2.5s;
            animation: fadein 0.5s, fadeout 0.5s 2.5s;
        }

        @-webkit-keyframes fadein {
            from {opacity: 0;}
            to {opacity: 1;}
        }

        @keyframes fadein {
            from {opacity: 0;}
            to {opacity: 1;}
        }

        @-webkit-keyframes fadeout {
            from {opacity: 1;}
            to {opacity: 0;}
        }

        @keyframes fadeout {
            from {opacity: 1;}
            to {opacity: 0;}
        }
    </style>

    <script>
        function showSnackbar(elementId) {
            var snackbar = document.getElementById(elementId);
            snackbar.className = "show";
            setTimeout(function(){ snackbar.className = snackbar.className.replace("show", ""); }, 3000);
        }

        @if (session('success'))
            showSnackbar('snackbar-success');
        @endif

        @if ($errors->any())
            showSnackbar('snackbar-error');
        @endif

    </script>
</body>
</html>
