<html data-dpr="1" style="font-size: 38px;">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width,user-scalable=no,initial-scale=1,maximum-scale=1,minimum-scale=1">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css">
    <title>Payment - CheckOut</title>
    <link href="{{asset('public')}}/api/css/style.css" rel="stylesheet">
    <style>
       /* General Styles */
* {
    box-sizing: border-box;
    margin: 0;
    padding: 0;
    font-family: Arial, sans-serif;
}

body {
    background-color: #f4f4f9;
    overflow-x: hidden;
}

/* Main Container */
.main {
    max-width: 800px;
    margin: 30px auto;
    padding: 20px;
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
}

/* Money Section */
.money_content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.money_title {
    font-size: 18px;
    font-weight: bold;
    color: #333;
}

.money {
    font-size: 14px;
    color: #555;
}

/* Content Section */
.content {
    padding: 20px;
    background-color: #f9f9f9;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.tx2 {
    font-size: 14px;
    color: #666;
    margin-bottom: 20px;
}

.tx3 {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.adminNumber {
    font-size: 16px;
    font-weight: bold;
    color: #333;
    overflow-wrap: break-word;
}

.pay_img img {
    width: 120px;
    height: auto;
}

/* Form Section */
.custom-form-group {
    margin-bottom: 15px;
}

.custom-form-group label {
    font-size: 14px;
    color: #333;
    display: block;
    margin-bottom: 5px;
}

.custom-form-control {
    width: 100%;
    padding: 10px;
    font-size: 14px;
    border: 1px solid #ddd;
    border-radius: 5px;
    box-sizing: border-box;
}

.custom-form-control:focus {
    border-color: #55b432;
    outline: none;
}

/* Button */
#submit {
    background-color: #55b432;
    color: #fff;
    border: none;
    padding: 12px 20px;
    font-size: 16px;
    border-radius: 5px;
    width: 100%;
    cursor: pointer;
    transition: background-color 0.3s ease;
}

#submit:hover {
    background-color: #499e2b;
}

.foot {
    padding: 20px;
}

/* Copy Link Button */
.tx3 img {
    cursor: pointer;
}

/* Responsive Design */
@media (max-width: 768px) {
    .main {
        padding: 15px;
    }

    .money_content {
        flex-direction: column;
        align-items: flex-start;
    }

    .pay_img img {
        width: 100px;
    }

    #submit {
        font-size: 14px;
    }
}


    </style>
    <link rel="stylesheet" href="{{asset('public')}}/api/css/layer.css" id="layuicss-layer">
</head>
<body class="overflow">
<form action="{{route('depositSubmit')}}" method="post" enctype="multipart/form-data">
    @csrf
    <input id="payment_method" name="payment_method" type="hidden" value="{{$payment_method->name}}">

    <div class="main" style="padding-top:0.2rem;background-color:#fff;">
        <div class="money_content">
            <span class="money_title" style="font-size:18px;">UPI CheckOut</span>
            <div class="money" style="font-size:14px">Total Amount Payable: <font id="money">
                    {{price($amount)}}
                </font>
            </div>
        </div>

        <div class="content" style="background-color:#fff0;box-shadow:none;">
            <div class="option"></div>
            <div class="pay_img" style="text-align: center;">
                <img class="ppImage" src="{{asset($payment_method->photo)}}">
            </div>
            <p class="tx2">
                Please upload the payment voucher within the specified time, otherwise the OTC has the right to cancel the order.
                <br>
                <span style="color: #446293;font-weight: 700;">Acceptable money should be sent money</span>
            </p>

            <div class="tx3">
                <div>
                    <div class="copied_message"></div>
                    <div>Copy this address.</div>
                    <div class="adminNumber">{{$payment_method->address}}</div>
                </div>
                <div><img onclick="copyLink('{{$payment_method->address}}')" src="https://img.icons8.com/material-sharp/24/copy.png" alt=""></div>
            </div>

            <div class="custom-form-group">
                <label for="amount">Selected Amount:</label>
                <input type="number" name="amount" id="amount" placeholder="amount" value="{{$amount}}" class="custom-form-control" readonly>
            </div>
            <div class="custom-form-group">
                <label for="number">Wallet name:</label>
                <input type="text" name="acc_acount" id="number" class="custom-form-control" placeholder="" value="{{$payment_method->name}}">
            </div>
            <div class="custom-form-group">
                <label for="trx">Enter your payment transaction ID:</label>
                <input type="text" name="transaction_id" id="trx" class="custom-form-control" placeholder="Transaction ID">
            </div>

            <div class="custom-form-group">
                <label for="photo">Payment evidence screenshot:</label>
                <input type="file" name="photo" id="photo" class="custom-form-control">
            </div>
        </div>
    </div>
</form>

</div>

<div class="foot" style="box-shadow:none;">
    <button id="submit" onclick="goPaymentForm()">
        Pay Confirm</button>
</div>

<input type="hidden" name="payment_operator">
<input type="hidden" name="copied_number">
<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js" type="text/javascript"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/js/materialize.min.js"></script>
@include('alert-message')
<script>
    let amount = '{{$amount}}';

    function goPaymentForm(){
        let current_amount = document.querySelector('input[name="amount"]').value;
        let number = document.querySelector('input[name="acc_acount"]').value;
        let trx = document.querySelector('input[name="transaction_id"]').value;

        if (current_amount < amount){
            message('Enter Sizes amount.')
            return 0;
        }

        if (number == ''){
            message('Enter your account name')
            return 0;
        }

        if (trx == ''){
            message('Enter transaction id')
            return 0;
        }

        document.querySelector('form').submit();
    }


    function copyLink(text)
    {
        const body = document.body;
        const input = document.createElement("input");
        body.append(input);
        input.style.opacity = 0;
        input.value = text.replaceAll(' ', '');
        input.select();
        input.setSelectionRange(0, input.value.length);
        document.execCommand("Copy");
        input.blur();
        input.remove();
        message('Address Copied...')
    }
</script>
</body>
</html>
