<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>Bank</title>
    <link rel="icon" type="image/png" href="/static/img/images.png">
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
@php
    $user = auth()->user();
@endphp
<body class="huiBg">
    <div class="top">
        <a href="/profile" class="topLeft">
            <i class="fas fa-arrow-left"></i>
        </a>
        <div class="topTit">Bind Account</div>
    </div>
    <div class="card-main">
        <form id="bindAccountForm" action="{{ route('setup.gateway.submit') }}" method="POST">
            @csrf
            <!--<div class="card-container">

                @if (session('success'))
                    <div id="snackbar-success">{{ session('success') }}</div>
                @endif
                @if ($errors->any())
                    <div id="snackbar-error">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif-->
                
                    
                </div>
                <div class="bind-account-field">
                    <label for="gateway_method" class="bind-account-label">Bank Type</label>
                    <select name="gateway_method" id="gateway_method" class="bind-account-input" required>
                        <option value="">Select Bank Type</option>
                        @foreach(\App\Models\BankList::where('status', '3')->get() as $elemenet)
                                        <option value="{{$elemenet->bank_code}}" @if($user->gateway_method == $elemenet->bank_code) selected @endif>{{$elemenet->name}}</option>
                                      @endforeach
                    </select>
                </div>
                <div class="bind-account-field">
                    <label for="phone" class="bind-account-label">Phone Number</label>
                    <input type="text" name="phone" id="phone" class="bind-account-input" placeholder="Phone Number" value="{{ auth()->user()->phone }}" readonly />
                </div>
                <div class="bind-account-field">
                    <label for="realname" class="bind-account-label">Holder Name</label>
                    <input type="text" name="realname" id="realname" class="bind-account-input" placeholder="Please enter holder name" required />
                </div>

                <div class="bind-account-field">
                    <label for="gateway_number" class="bind-account-label">Bank Account Number</label>
                    <input type="text" name="gateway_number" id="gateway_number" class="bind-account-input" placeholder="Please enter bank account number" value="" required />
                </div>
                
                <button type="button" class="bind-account-btn" onclick="submitBank()">Confirm</button>
            </div>
        </form>

    </div>
@include('alert-message')
    <div class="loadingClass" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); color: white; text-align: center; padding-top: 20%; font-size: 20px; z-index: 9999;">
        Wait...
    </div>

    <style>
        /* Page Container with margins */
        body {
            padding-left: 16px;
            padding-right: 16px;
        }

        .card-main {
            padding-left: 0;
            padding-right: 0;
        }

        .top {
            margin-left: -16px;
            margin-right: -16px;
            padding-left: 16px;
            padding-right: 16px;
            background: #004831 !important;
            color: #ffffff;
        }

        .topTit {
            color: #ffffff;
        }

        .topLeft i {
            color: #ffffff;
        }

        /* Bind Account Page - Compact Styling (20-25% reduction) */
        .bind-account-field {
            width: 100%;
            margin-bottom: 12px; /* Reduced from 20px (40% reduction for compact spacing) */
        }

        .bind-account-label {
            display: block;
            font-size: 13px;
            color: #004831;
            font-weight: 500;
            margin-bottom: 6px;
            text-align: left;
        }

        .bind-account-input {
            width: 100%;
            height: 34px; /* Reduced from 45px (25% reduction) */
            background: #ffffff;
            border: 1px solid #004831;
            border-radius: 6px; /* Modern border-radius */
            padding: 0 7.5px; /* Reduced from 0 10px (25% reduction) */
            color: #004831;
            font-size: 14px; /* Slightly reduced font size */
            box-shadow: 0 2px 4px rgba(72, 99, 160, 0.1); /* Modern shadow */
            transition: all 0.3s ease;
            box-sizing: border-box;
        }

        .bind-account-input:focus {
            outline: none;
            border-color: #3A4E7F;
            box-shadow: 0 2px 8px rgba(72, 99, 160, 0.2); /* Enhanced shadow on focus */
        }

        .bind-account-input::placeholder {
            color: #999;
            font-size: 13px; /* Slightly smaller placeholder */
        }

        .bind-account-input[readonly] {
            background-color: #f5f5f5;
            cursor: not-allowed;
        }

        .bind-account-btn {
            width: 100%;
            height: 34px; /* Reduced from 45px (25% reduction) */
            background: #004831;
            color: #ffffff;
            line-height: 34px; /* Match height for vertical centering */
            border-radius: 6px; /* Modern border-radius */
            border: none;
            font-weight: 600;
            font-size: 15px; /* Slightly reduced from default */
            margin-top: 8px;
            box-shadow: 0 2px 6px rgba(72, 99, 160, 0.3); /* Modern shadow */
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .bind-account-btn:hover {
            background: #3A4E7F;
            box-shadow: 0 4px 8px rgba(72, 99, 160, 0.4); /* Enhanced shadow on hover */
            transform: translateY(-1px);
        }

        .bind-account-btn:active {
            transform: translateY(0);
            box-shadow: 0 2px 4px rgba(72, 99, 160, 0.3);
        }

        /* Responsive adjustments */
        @media (max-width: 480px) {
            body {
                padding-left: 12px;
                padding-right: 12px;
            }

            .top {
                margin-left: -12px;
                margin-right: -12px;
                padding-left: 12px;
                padding-right: 12px;
            }

            .bind-account-field {
                margin-bottom: 10px;
            }

            .bind-account-input {
                height: 32px;
                font-size: 13px;
                padding: 0 6px;
            }

            .bind-account-btn {
                height: 32px;
                line-height: 32px;
                font-size: 14px;
            }

            .bind-account-label {
                font-size: 12px;
                margin-bottom: 5px;
            }
        }

        @media (max-width: 360px) {
            body {
                padding-left: 10px;
                padding-right: 10px;
            }

            .top {
                margin-left: -10px;
                margin-right: -10px;
                padding-left: 10px;
                padding-right: 10px;
            }

            .bind-account-input {
                height: 30px;
                font-size: 12px;
            }

            .bind-account-btn {
                height: 30px;
                line-height: 30px;
                font-size: 13px;
            }
        }

        /* Snackbar styles */
        #snackbar-success, #snackbar-error {
            visibility: hidden;
            min-width: 250px;
            margin-left: -125px;
            background-color: #333; 
            color: #fff; 
            text-align: center;
            border-radius: 4px;
            padding: 16px;
            position: fixed;
            z-index: 9999;
            left: 50%;
            top: 50%; 
            transform: translate(-50%, -50%); 
            font-size: 17px;
        }

        #snackbar-success.show, #snackbar-error.show {
            visibility: visible;
            -webkit-animation: fadein 0.5s, fadeout 0.5s 2.5s;
            animation: fadein 0.5s, fadeout 0.5s 2.5s;
        }

        @-webkit-keyframes fadein {
            from {opacity: 0;}
            to {opacity: 1;}
        }

        @keyframes fadein {
            from {opacity: 0;}
            to {opacity: 1;}
        }

        @-webkit-keyframes fadeout {
            from {opacity: 1;}
            to {opacity: 0;}
        }

        @keyframes fadeout {
            from {opacity: 1;}
            to {opacity: 0;}
        }
    </style>

    <script>
        function showSnackbar(elementId) {
            var snackbar = document.getElementById(elementId);
            snackbar.className = "show";
            setTimeout(function(){ snackbar.className = snackbar.className.replace("show", ""); }, 3000);
        }

        @if (session('success'))
            showSnackbar('snackbar-success');
        @endif

        @if ($errors->any())
            showSnackbar('snackbar-error');
        @endif

        function submitBank() {
            document.querySelector('.loadingClass').style.display = 'block';
            
            document.getElementById('bindAccountForm').submit();
        }
    </script>
</body>
