<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>History</title>
    <link rel="icon" type="image/png" href="/static/img/images.png">
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .top {
            background: #004831 !important;
        }
        .record-tab .tab-link.active {
            color: #000000 !important;
        }
        .record-tab .tab-link:hover {
            background: #A0C81E !important;
            color: #000000 !important;
        }
        .list-right span {
            background: #A0C81E !important;
            color: #000000 !important;
        }
        .list-right span.disabled {
            background: #999999 !important;
            color: #ffffff !important;
        }
    </style>
</head>
<body class="homeColor">
    <div class="top">
        <a href="/profile" class="topLeft">
            <i class="layui-icon layui-icon-left"></i>
        </a>
        <div class="topTit">Cash Record</div>
    </div>

    <div class="history-main">
        <div class="record-tab">
            <a href="#" data-tab="cash" class="tab-link active">Cash</a>
            <a href="#" data-tab="recharge" class="tab-link">Recharge</a>
            <a href="#" data-tab="withdraw" class="tab-link">Withdraw</a>
        </div>
        
        <div id="cash-records" class="history-list" style="display: block;">
            @foreach($cashRecords as $record)
                @if($record->amount > 0)
                <div class="list-item">
                    <div class="list-left">
                        <h3>{{ $record->title }}</h3>
                        <p>{{ \Carbon\Carbon::parse($record->created_at)->format('M,d,Y,H:i:s') }}</p>
                    </div>
                    <div class="list-right">
                        @php
                            // Product Income and other income types should always show + (adds to balance)
                            // Even if database has wrong debit/credit values
                            $incomeReasons = ['daily_income', 'income_commission', 'commission', 'claim', 'my_commission', 'reg_bonus', 'referral_bonus', 'check_in_reward', 'monthly_salary', 'weekly_salary', 'daily_reward', 'gift_bonus', 'wheel_win', 'capital_return'];
                            $expenseReasons = ['product_purchase', 'withdraw_request', 'withdraw_approved'];
                            
                            $isIncome = in_array($record->reason, $incomeReasons);
                            $isExpense = in_array($record->reason, $expenseReasons);
                        @endphp
                        @if($isExpense)
                            - {{ price($record->amount) }}
                        @elseif($isIncome)
                            + {{ price($record->amount) }}
                        @elseif($record->debit > 0)
                            - {{ price($record->amount) }}
                        @elseif($record->credit > 0)
                            + {{ price($record->amount) }}
                        @else
                            {{ price($record->amount) }}
                        @endif
                    </div>
                </div>
                @endif
            @endforeach
        </div>

        <div id="recharge-records" class="history-list" style="display: none;">
            @foreach($rechargeRecords as $record)
                @if($record->final_amount > 0)
                <div class="list-item">
                    <div class="list-left">
                        <h3>{{ $record->order_id }}</h3>
                        <p>{{ \Carbon\Carbon::parse($record->created_at)->format('M,d,Y,H:i:s') }}</p>
                    </div>
                    <div class="list-right">
                        + {{ price($record->final_amount )}}
                        <span class="{{ $record->status === 'approved' ? '' : 'disabled' }}">
                            {{ $record->status === 'approved' ? 'Success' : ($record->status === 'rejected' ? 'Failed' : ucfirst($record->status)) }}
                        </span>
                    </div>
                </div>
                @endif
            @endforeach
        </div>

        <div id="withdraw-records" class="history-list" style="display: none;">
    @foreach($withdrawRecords as $record)
        @if($record->amount > 0)
        <div class="list-item">
            <div class="list-left">
                <h3>{{ $record->oid }}</h3>
                <p>{{ \Carbon\Carbon::parse($record->created_at)->format('M d, Y H:i:s') }}</p>
            </div>
            <div class="list-right">
                - {{ price($record->amount) }}
                <span class="{{ $record->status === 'approved' ? '' : 'disabled' }}"> 
                @switch($record->status)
    @case('approved')
        succeeded
        @break
    @case('pending')
        Processing
        @break
    @case('rejected')
        Failed
        @break
    @default
        {{ ucfirst($record->status) }}
@endswitch

                
                   <!-- @switch($record->status)
                        @case('approved')
                            Success
                            @break
                        @case('processing')
                            Processing
                            @break
                        @case('rejected')
                            Failed
                            @break
                        @default
                            {{ ucfirst($record->status) }}
                    @endswitch-->
                </span>
            </div>
        </div>
        @endif
    @endforeach

        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const tabs = document.querySelectorAll('.tab-link');
            const recordSections = document.querySelectorAll('.history-list');
            
            tabs.forEach(tab => {
                tab.addEventListener('click', function (event) {
                    event.preventDefault();

                    tabs.forEach(t => t.classList.remove('active'));
                    recordSections.forEach(section => section.style.display = 'none');

                    this.classList.add('active');
                    
                    const target = this.getAttribute('data-tab');
                    document.getElementById(target + '-records').style.display = 'block';
                });
            });
        });
    </script>
</body>
</html>
