<!DOCTYPE html>
<html lang="en">
<head>
 <!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-T3XGKYQQNJ"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-T3XGKYQQNJ');
</script>   
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
  <title>Dashboard</title>
  <link rel="icon" type="image/png" href="/static/img/images.png">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css"/>
  <!-- Global Color Scheme -->
  <link rel="stylesheet" href="{{asset('public/assets/global-colors.css')}}">
  <style>
    body {
      background: #ffffff !important;
      font-family: 'Segoe UI', sans-serif;
      margin: 0;
      padding-bottom: 80px;
    }

    /* Gradient Top Bar */
    .top-header {
      background: linear-gradient(135deg, #004831, #003d28); /* IDG Capital Green */
      padding: 14px 16px;
      color: #fff;
      position: sticky;
      top: 0;
      z-index: 100;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .top-header .title {
      font-size: 18px;
      font-weight: bold;
    }

    .top-header img.avatar {
      width: 32px;
      height: 32px;
      border-radius: 50%;
      object-fit: cover;
    }

    .top-header .icons i {
      font-size: 20px;
      margin-left: 14px;
      cursor: pointer;
    }

    /* Banner */
    .carousel-container {
      margin: 12px 10px;
      border-radius: 14px;
      overflow: hidden;
    }

    .layui-carousel img {
      width: 100%;
      height: 180px;
      object-fit: cover;
      border-radius: 12px;
    }

    /* ROI Cards */
    .roi-stats {
      display: flex;
      justify-content: space-between;
      margin: 10px;
      gap: 10px;
    }

    .roi-card {
      flex: 1;
      background: #fff;
      border-radius: 10px;
      padding: 12px;
      text-align: center;
      box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }

    .roi-card h3 {
      font-size: 13px;
      color: #666;
    }

    .roi-card p {
      margin-top: 4px;
      font-size: 16px;
      font-weight: bold;
      color: #004831; /* IDG Capital Green */
    }

    /* Balance Card */
    .balance-card {
      background: linear-gradient(to right, #e8f5e9, #ffffff); /* IDG Capital Green Tint */
      margin: 15px 10px;
      border-radius: 14px;
      padding: 16px;
      box-shadow: 0 4px 8px rgba(0,0,0,0.04);
      display: flex;
      justify-content: space-around;
    }

    .balance-card .item {
      text-align: center;
    }

    .balance-card .item img {
      width: 24px;
      height: 24px;
      margin-bottom: 4px;
    }

.top-header .icons a {
    color: #fff; 
    text-decoration: none;
}
    .balance-card .item .label {
      font-size: 13px;
      color: #444;
    }

    .balance-card .item .value {
      font-size: 15px;
      font-weight: bold;
      color: #004831; /* IDG Capital Green */
    }

    /* Quick Actions */
    .quick-actions {
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      gap: 10px;
      margin: 10px;
    }

    .action-btn {
      background: #fff;
      padding: 10px 6px;
      border-radius: 12px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.06);
      text-align: center;
      transition: all 0.3s;
    }

    .action-btn:hover {
      transform: translateY(-3px);
      box-shadow: 0 4px 10px rgba(0,0,0,0.1);
    }

    .action-btn img {
      width: 30px;
      height: 30px;
      margin-bottom: 4px;
    }

    .action-btn div {
      font-size: 13px;
      color: #222;
    }


    /* Event Section */
    .section-title {
      margin: 15px 10px 8px;
      font-weight: bold;
      color: #004831; /* IDG Capital Green */
      border-left: 4px solid #004831; /* IDG Capital Green */
      padding-left: 8px;
    }


    /* Support Badge */
    .support-badge {
      position: fixed;
      bottom: 20px;
      right: 20px;
      background: #004831; /* IDG Capital Green */
      color: white;
      font-weight: bold;
      padding: 8px 12px;
      border-radius: 20px;
      box-shadow: 0 3px 10px rgba(0,0,0,0.1);
      font-size: 14px;
    }

    /* Scroll Notice */
    .scroll-notice {
      background: #e8f5e9; /* IDG Capital Green Tint */
      margin: 10px;
      padding: 6px 12px;
      font-size: 14px;
      color: #004831; /* IDG Capital Green */
      white-space: nowrap;
      overflow: hidden;
      border-radius: 6px;
    }

    .scroll-notice span {
      display: inline-block;
      animation: scroll-left 12s linear infinite;
    }

    @keyframes scroll-left {
      from { transform: translateX(100%); }
      to { transform: translateX(-100%); }
    }
    .tab-buttons {
      display: flex;
      gap: 10px;
      padding: 15px;
      background: #fff;
      position: sticky;
      top: 58px;
      z-index: 90;
      box-shadow: 0 2px 5px rgba(0,0,0,0.04);
    }

    .tab-buttons button {
      flex: 1;
      padding: 10px;
      font-size: 15px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      background: #ccc;
      color: #fff;
      transition: 0.3s;
    }

    .tab-buttons button.active {
      background: #004831; /* IDG Capital Green */
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }

    .product-tab {
      display: none;
      animation: fadeIn 0.3s ease;
      background: transparent !important;
    }

    .product-tab.active {
      display: block;
      background: transparent !important;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(5px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .product-box {
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.06);
      margin: 25px 15px 15px 15px; /* Adjusted margin for the new header */
      overflow: visible; /* Allow header to overlap */
      transition: transform 0.2s;
      position: relative; /* Needed for header positioning */
    }

    .product-box:hover {
      transform: scale(1.01);
    }

    .product-box.discount {
      background: #fffce6;
      border: 1px solid #f4c430;
    }

    .product-box.soldout {
      opacity: 0.6;
      pointer-events: none;
    }

    .product-header {
      background: #004831; /* IDG Capital Green */
      color: #fff;
      padding: 10px 20px;
      font-weight: bold;
      position: absolute;
      top: -15px; /* Overlap effect */
      left: 50%;
      transform: translateX(-50%);
      width: 95%;
      border-radius: 20px; /* Pill shape */
      display: flex;
      justify-content: space-between;
      align-items: center;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      z-index: 2;
    }

    .badge {
      background: #A0C81E; /* Light green oval */
      color: #000;
      padding: 4px 10px;
      font-size: 13px;
      border-radius: 20px; /* Oval shape */
      font-weight: 600;
      white-space: nowrap;
    }

    .product-body {
      padding: 15px;
      padding-top: 40px; /* Push content below the overlapping header */
    }

    .product-content {
      display: flex;
      gap: 12px;
    }

    .product-left img {
      width: 85px;
      height: 85px;
      object-fit: cover;
      border-radius: 8px;
    }

    .product-info {
      flex: 1;
      font-size: 14px;
      color: #333;
    }

    .product-info p {
      margin: 6px 0;
      display: flex;
      justify-content: space-between;
    }

    .product-info span {
      color: #004831; /* IDG Capital Green */
      font-weight: 600;
    }

    .product-footer {
      margin-top: 10px;
      display: flex;
      justify-content: space-between;
      flex-wrap: wrap;
      align-items: center;
    }

    .price-discount {
      font-size: 14px;
    }

    .original-price {
      text-decoration: line-through;
      color: #888;
    }

    .discounted-price {
      color: red;
      font-weight: bold;
    }

    .countdown {
      font-size: 12px;
      color: #666;
      margin-top: 5px;
    }

    .rent-btn {
      background: #A0C81E; /* IDG Capital Button Green */
      color: #000000;
      padding: 6px 15px;
      border-radius: 20px;
      text-decoration: none;
      transition: 0.3s;
    }

    .rent-btn:hover {
      background: #8fb01a; /* Darker shade on hover */
    }

    .rent-btn.disabled {
      background: #222;
      pointer-events: none;
    }

    .no-more {
      text-align: center;
      color: #888;
      margin: 25px 0 5px;
      font-size: 14px;
    }
    .turntable {
    width: 56px;
    height: 56px;
    position: fixed;
    bottom: 120px;
    right: 3px;
    z-index: 5000;
}

.turntable a {
    width: 56px;
    height: 56px;
    display: inline-block;
    background: #ffffff;
    border-radius: 50%;
    margin: 5px 0;
    overflow: hidden;
}

.turntable img {
    width: 100%;
    animation: rotate 2s linear infinite;
    -webkit-animation: rotate 2s linear infinite;
    -moz-animation: rotate 2s linear infinite;
}
/*home-notice*
body {
      margin: 0;
      padding: 0;
      font-family: "Segoe UI", sans-serif;
      background: #f2f2f2;
    }*/

    .overlay {
      position: fixed;
      inset: 0;
      background: rgba(0, 0, 0, 0.6);
      display: none; /* Initially hidden */
      align-items: center;
      justify-content: center;
      z-index: 999;
    }

    .popup {
      background: white;
      width: 90%;
      max-width: 400px;
      border-radius: 16px;
      padding: 20px;
      position: relative;
      box-shadow: 0 8px 16px rgba(0, 0, 0, 0.25);
      color: #0d1b3d;
      font-size: 14px;
      animation: fadeIn 0.4s ease-in-out;
    }

    @keyframes fadeIn {
      from { transform: scale(0.9); opacity: 0; }
      to { transform: scale(1); opacity: 1; }
    }

    .popup .close-btn {
      position: absolute;
      top: 10px;
      right: 14px;
      font-size: 18px;
      color: #4f46e5;
      cursor: pointer;
    }

    .popup p {
      margin: 10px 0;
      line-height: 1.6;
    }

    .popup p span {
      font-weight: bold;
    }

    .popup p:first-child span {
      color: red;
    }

    .popup button {
      display: block;
      width: 100%;
      margin-top: 12px;
      background-color: #A0C81E; /* IDG Capital Button Green */
      color: #000000 !important;
      border: none;
      border-radius: 25px;
      padding: 12px 0;
      font-size: 16px;
      text-align: center;
      text-decoration: none;
      cursor: pointer;
    }

    .popup a.join-btn {
      display: block;
      width: 100%;
      margin-top: 12px;
      background-color: #A0C81E; /* IDG Capital Button Green */
      color: white;
      border: none;
      border-radius: 25px;
      padding: 12px 0;
      font-size: 16px;
      text-align: center;
      text-decoration: none;
      cursor: pointer;
    }

    .popup a.join-btn {
      background-color: #004831; /* WhatsApp green */
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
      font-weight: bold;
      box-shadow: 0 0 12px #25D36688;
      margin-top: 16px;
      transition: transform 0.2s;
    }

    .popup a.join-btn:hover {
      transform: scale(1.03);
    }

    .popup a.join-btn img {
      width: 20px;
      height: 20px;
    }

    /* Ensure Confirm button text is black, separate from Telegram button */
    /* This rule must come after join-btn to override any combined selectors */
    .popup button[onclick="closePopup()"],
    .popup button:not(.join-btn) {
      color: #000000 !important;
    }

    .emoji {
      margin-right: 6px;
    }

    .emoji {
      margin-right: 6px;
    }
    @media (max-width: 600px) {
              .header-container {
                  height: 30vh;
              }
              .button-bar .button {
                  flex: 1;
                  min-width: 60px;
              }
          }

          @media (max-width: 400px) {
              .button-bar .button {
                  flex: 1 1 100%;
                  max-width: none;
              }

          }

  </style>
</head>
<body>

  <!-- Top Header -->
  <div class="top-header">
    <div class="title">Home</div>
    <div class="icons">
        <a href="{{ url('/services') }}" target="_blank">
            <i class="layui-icon layui-icon-headset"></i>
        </a>
    </div>
  </div>

  <!-- Banner -->
  <div class="carousel-container">
    <div class="layui-carousel" id="banner-carousel">
      <div carousel-item>
        <img src="{{ asset('public/banner/aibanner.jpg') }}" alt="Banner 1">
      </div>
    </div>
  </div>


  <!-- ROI Stats --
  <div class="roi-stats">
    <div class="roi-card">
      <h3>Total Invested</h3>
      <p>₦100,000</p>
    </div>
    <div class="roi-card">
      <h3>Total Earned</h3>
      <p>₦58,300</p>
    </div>
    <div class="roi-card">
      <h3>ROI %</h3>
      <p>58.3%</p>
    </div>
  </div>

  <!-- Balance Card -->


  <!-- Quick Actions --
  <div class="quick-actions">
    <div class="action-btn">
      <img src="{{ asset('static/img/Account (1).png') }}" alt="recharge">
      <div>Recharge</div></a>
    </div>
    <div class="action-btn">
      <img src="{{ asset('static/img/about.png') }}" alt="about.png">
      <div>About</div>
    </div>
    <div class="action-btn" onclick="window.location.href='{{ route('user.team') }}">
      <img src="{{ asset('static/img/Team_2.png') }}" alt="Team">
      <div>Team </div>
    </div>
    <div class="action-btn" onclick="window.location.href='{{ route('user.withdraw') }}">
      <img src="{{ asset('static/img/msg.png') }}" alt="withdraw">
      <div>withdraw</div>
    </div>
    <div class="action-btn">
      <img src="{{ asset('static/img/bonus.png') }}" alt="bonus">
      <div>Redeem</div>
    </div>
    <div class="action-btn">
      <img src="{{ asset('static/img/Order_2 (1).png') }}" alt="adoption">
      <div>my adoption</div>
    </div>
    <div class="action-btn" onclick="window.location.href='{{ url('/check-in-page') }}">
      <img src="{{ asset('static/img/m_11.png') }}" alt="daily check-in">
      <div>daily check-in</div>
    </div>
    <div class="action-btn">
      <img src="{{ asset('static/img/service (1).png') }}" alt="support">
      <div>Support</div>
    </div>
  </div>-->
  <!-- Quick Actions -->
<div class="quick-actions">

  <div class="action-btn" onclick="window.location.href='{{ url('deposit') }}'">
    <img src="{{ asset('static/img/Account (1).png') }}" alt="Recharge">
    <div>Recharge</div>
  </div>

  <div class="action-btn" onclick="window.location.href='{{ url('/about') }}'">
    <img src="{{ asset('static/img/about.png') }}" alt="About Us">
    <div>About</div>
  </div>

  <div class="action-btn" onclick="window.location.href='{{ url('my-team') }}'">
    <img src="{{ asset('static/img/Team_2.png') }}" alt="Team">
    <div>Team</div>
  </div>

  <div class="action-btn" onclick="window.location.href='{{ url('withdraw') }}'">
    <img src="{{ asset('static/img/msg.png') }}" alt="Withdraw">
    <div>Withdraw</div>
  </div>

  <div class="action-btn" onclick="window.location.href='{{ url('/spin') }}'">
    <img src="{{ asset('public/images/profile/m_4.png') }}" alt="Redeem">
    <div>Bonus Code</div>
  </div>

  <div class="action-btn" onclick="window.location.href='{{ url('ordered') }}'">
    <img src="{{ asset('public/images/profile/m_5.png') }}" alt="My Adoption">
    <div>My Products</div>
  </div>

  <div class="action-btn" onclick="window.location.href='{{ url('/check-in-page') }}'">
    <img src="{{ asset('static/img/m_11.png') }}" alt="Daily Check-in">
    <div>Daily Check-in</div>
  </div>

  <div class="action-btn" onclick="window.location.href='{{ route('user.job.index') }}'">
    <img src="{{ asset('static/img/spin.png') }}" alt="Jobs">
    <div>Salary</div>
  </div>

  <div class="action-btn" onclick="window.location.href='{{ url('/add-bank') }}'">
    <img src="{{ asset('public/images/profile/m_3.png') }}" alt="Support">
    <div>Bind Account</div>
  </div>

</div>
<div class="turntable">
   <a href="/wheel"> <img src="{{ asset('static/img/spin.png') }}"> </a>
  </div>

  <!-- Events -->
  <div class="section-title"> Products</div>
  <div class="event-cards">
      <main>
    @php
      use App\Models\Package;
      $packages = Package::where('status', 'active')->orderBy('display_order', 'asc')->get()->groupBy('type');
    @endphp

    <!-- Tabs --
    <div class="tab-buttons">
      <button class="active" onclick="showTab(event, 'fixed')">Fixed</button>
      <button onclick="showTab(event, 'welfare')">Welfare</button>
      <button onclick="showTab(event, 'activity')">Activity</button>
    </div>-->

    @foreach(['fixed', 'welfare', 'activity'] as $cat)
      <div class="product-tab {{ $loop->first ? 'active' : '' }}" id="{{ $cat }}">
        @foreach ($packages[$cat] ?? [] as $package)
          @php
            $isDiscounted = $package->discount_percentage > 0;
            $dailyIncome = round($package->commission_with_avg_amount / $package->validity, 2);
            
            // Check for VIP Commission tiers
            $vipCommissions = json_decode($package->vip_commission, true);
            $hasVipTiers = is_array($vipCommissions) && count($vipCommissions) > 0;
            
            if ($hasVipTiers) {
                // Get min and max income from VIP tiers
                $incomes = array_column($vipCommissions, 'income');
                $minIncome = min($incomes);
                $maxIncome = max($incomes);
            }
            
            // Calculate current purchase count for this user
            $currentPurchaseCount = \App\Models\Purchase::where('user_id', auth()->id())
                ->where('package_id', $package->id)
                ->where('status', 'active')
                ->count();
            // Set buy limit using same logic as ProductController
            $buyLimit = $package->buy_limit ?? ($package->price > 0 ? 2 : 1);
          @endphp
          <div class="product-box {{ $isDiscounted ? 'discount' : '' }} {{ $package->is_sold_out ? 'soldout' : '' }}">
            <div class="product-header">
              {{ $package->name }}
              <span class="badge">{{ $currentPurchaseCount }}/{{ $buyLimit }}</span>
            </div>
            <div class="product-body">
              <div class="product-content">
                <div class="product-left">
                  <img src="{{asset( $package->photo) }}" alt="{{ $package->name }}">
                </div>
                <div class="product-info">
                  <p>Purchase Price: <span>{{ price($package->price) }} </span></p>
                  <p>Validity: <span>{{ $package->validity }} Days</span></p>
                  <p>Daily Profit: 
                    <span>
                      @if($package->price > 0)
                        @if($hasVipTiers)
                            {{ round(($minIncome / $package->price) * 100, 2) }}% ~ {{ round(($maxIncome / $package->price) * 100, 2) }}%
                        @else
                            {{ round(($dailyIncome / $package->price) * 100, 2) }}%
                        @endif
                      @else
                        0%
                      @endif
                    </span>
                  </p>
                  <p>Daily income: 
                    <span>
                      @if($hasVipTiers)
                        {{ price($minIncome) }} ~ {{ price($maxIncome) }}
                      @else
                        {{ price($dailyIncome) }}
                      @endif
                    </span>
                  </p>
                  <p>Revenue: 
                    <span>
                      @if($hasVipTiers)
                        {{ price($minIncome * $package->validity) }} ~ {{ price($maxIncome * $package->validity) }}
                      @else
                        {{ price($package->commission_with_avg_amount) }}
                      @endif
                    </span>
                  </p>
                </div>
              </div>
              <div class="product-footer">
                <div class="price-discount">
                  @if($isDiscounted)
                    <span class="original-price">{{ price($package->price) }} </span>
                    <span class="discounted-price">{{ price($package->discounted_price) }} </span>
                  @else
                    <span class="discounted-price">{{ price($package->price) }}</span>
                  @endif
                  @if($package->show_timer)
                    <div class="countdown" data-end="{{ now()->addDays(2)->toIso8601String() }}"></div>
                  @endif
                </div>
                <a href="{{ route('product.detail', ['id' => $package->id]) }}"
                   class="rent-btn {{ $package->is_sold_out ? 'disabled' : '' }}">
                  {{ $package->is_sold_out ? 'Sold Out' : 'Invest Now' }}
                </a>
              </div>
            </div>
          </div>
        @endforeach
      </div>
    @endforeach

    <div class="no-more">— No more —</div>
  </main>

  <div class="overlay" id="popupNotice">
  <div class="popup">
    <div class="close-btn" onclick="closePopup()">❌</div>

    <p><span class="emoji"></span><span></span><b>AI CASH💸</b></p>
      <p><strong>Minimum Recharge:</strong> 400 BDT</p>
      <p><strong>Minimum Withdrawal:</strong> 200 BDT</p>
      <p><strong>Invitation Commission:</strong> 10%+6%+1%</p>
      <p><strong>Withdrawal Time:</strong> 11:00 AM - 6:00 PM</p>
      <p><strong>Withdrawal Charge:</strong> 10%</p>
    

    <button onclick="closePopup()">Confirm</button>

    <a class="join-btn" href="{{ url('/services') }}" target="_blank">
  <img src="https://upload.wikimedia.org/wikipedia/commons/8/82/Telegram_logo.svg" alt="Telegram Logo">
  Join Telegram Service
</a>
  </div>
</div>
@include('app.layout.manu')
<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

<script>
    const swiperContainer = new Swiper('.swiper-container', {

        loop: true,
        autoplay: {
            delay: 3000,
            disableOnInteraction: false,
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
    });

    const swiper = new Swiper('.swiper', {
        direction: 'vertical',
        loop: true,
        autoplay: {
            delay: 3000,
            disableOnInteraction: false,
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
    });
</script>
<script>
    // Wait for the DOM to fully load
    document.addEventListener("DOMContentLoaded", function () {
        const modal = document.getElementById("popupNotice");
        // Ensure the modal exists before trying to access it
        if (modal) {
            // Show the modal after 2 seconds
            setTimeout(() => {
                // The overlay uses flexbox for centering
                modal.style.display = "flex";
            }, 2000);
        }
    });
</script>
<script>
  function closePopup() {
    document.getElementById('popupNotice').style.display = 'none';
  }
</script>

  <script>
    function showTab(evt, tabId) {
      document.querySelectorAll('.product-tab').forEach(tab => tab.classList.remove('active'));
      document.querySelectorAll('.tab-buttons button').forEach(btn => btn.classList.remove('active'));
      document.getElementById(tabId).classList.add('active');
      evt.target.classList.add('active');
    }

    function updateCountdowns() {
      const now = new Date();
      document.querySelectorAll('.countdown').forEach(el => {
        const end = new Date(el.getAttribute('data-end'));
        const diff = end - now;
        if (diff > 0) {
          const d = Math.floor(diff / (1000 * 60 * 60 * 24));
          const h = Math.floor((diff / (1000 * 60 * 60)) % 24);
          const m = Math.floor((diff / (1000 * 60)) % 60);
          const s = Math.floor((diff / 1000) % 60);
          el.textContent = `⏳ ${d}d ${h}h ${m}m ${s}s`;
        } else {
          el.textContent = '⏰ Expired';
        }
      });
    }

    setInterval(updateCountdowns, 1000);
    updateCountdowns();
  </script>

  <!-- JS -->
  <script src="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/layui.js"></script>
  <script>
    layui.use('carousel', function(){
      var carousel = layui.carousel;
      carousel.render({
        elem: '#banner-carousel',
        width: '100%',
        height: '180px',
        interval: 3000,
        anim: 'fade',
        arrow: 'none'
      });
    });
  </script>

</body>
</html>



