<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover">
  <title>My Product</title>
  <link rel="icon" type="image/png" href="/static/img/images.png">
  <link rel="stylesheet" href="/static/reset.css">
  <link rel="stylesheet" href="/static/style.css">
  <link rel="stylesheet" href="/static/layui.css">
  <script src="/static/layui.js"></script>
  <script src="/static/jquery-3.5.1.min.js"></script>
  <style>
    .top {
        background: #004831 !important;
    }
    /* Next Settlement Time Color Styling */
    .settlement-time-valid {
      color: #28a745 !important; /* Green for valid products */
      font-weight: 600;
    }
    
    .settlement-time-expired {
      color: #dc3545 !important; /* Red for expired products */
      font-weight: 600;
    }
    .record-tab .tab-link.active {
        color: #000000 !important;
    }
    .record-tab .tab-link:hover {
        background: #A0C81E !important;
        color: #000000 !important;
    }
  </style>
</head>

<body class="homeColor">
  <div class="top">
    <a href="/profile" class="topLeft">
      <i class="layui-icon layui-icon-left"></i>
    </a>
    <div class="topTit">My Product</div>
  </div>

  @php
    $totalAssets = \App\Models\Purchase::where('user_id', auth()->id())
        ->where('status', 'active')
        ->count();
  @endphp

  <div class="myorder">
    <div class="balance-list">
      <div class="balance-item">
        <h3>{{ $totalAssets }}</h3>
        <p>Total Assets</p>
      </div>
      <div class="balance-item">
        <h3>{{ number_format(auth()->user()->product_income,2); }}</h3>
        <p>Total Income</p>
      </div>
    </div>

    <div class="record-tab">
      <a href="javascript:void(0);" class="tab-link active" data-status="active">Valid</a>
      <a href="javascript:void(0);" class="tab-link" data-status="inactive">Expired</a>
    </div>

    <div class="order-list" id="order-lis">
      @php
        $activePackages = \App\Models\Purchase::where('user_id', auth()->id())
          ->where('status', 'active')
          ->with('package')
          ->get();

        $inactivePackages = \App\Models\Purchase::where('user_id', auth()->id())
          ->where('status', 'inactive')
          ->with('package')
          ->get();
      @endphp

      @foreach($activePackages as $purchase)
        @php
          $endDate = $purchase->validity ? \Carbon\Carbon::parse($purchase->validity) : \Carbon\Carbon::parse($purchase->created_at)->addDays($purchase->package->validity);
          $isExpired = now()->greaterThan($endDate);
          $nextSettlement = $purchase->date ? \Carbon\Carbon::parse($purchase->date) : \Carbon\Carbon::parse($purchase->created_at)->addHours(24);
          
          // Calculate actual daily income based on VIP level
          $dailyIncome = $purchase->package->daily_income;
          $vipCommissions = json_decode($purchase->package->vip_commission, true);
          
          if (is_array($vipCommissions) && count($vipCommissions) > 0) {
              $referralCount = auth()->user()->validDirectReferralsCount();
              // Find the highest tier met by the user
              foreach ($vipCommissions as $vc) {
                  if ($referralCount >= $vc['referrals']) {
                      $dailyIncome = $vc['income'];
                  }
              }
          }
        @endphp
        <div class="product-info active">
          <div class="product-img">
            <img src="{{ asset($purchase->package->photo) }}" alt="Product Image: {{ $purchase->package->name }}">
          </div>
          <div class="product-text">
            <h3>{{ $purchase->package->name }}</h3>
            <p>Price: <span>{{ price($purchase->package->price )}} </span></p>
            <p>Cycle: <span>{{ $purchase->package->validity }} Days</span></p>
            <p>Daily Income: <span>{{ price($dailyIncome) }}  </span></p>
            <p>Total Revenue: <span>{{ price($dailyIncome * $purchase->package->validity) }}</span></p>
            <p>Purchase Date: <span>{{ \Carbon\Carbon::parse($purchase->created_at)->format('M d, Y') }}</span></p>
            <p>End Date: <span>{{ $endDate->format('M d, Y') }}</span></p>
            <p>Next Settlement Time: <span class="@if($isExpired)settlement-time-expired@else settlement-time-valid @endif">@if($isExpired)<strong>Expired</strong>@else{{ $nextSettlement->format('M d, Y H:i') }}@endif</span></p>
          </div>
        </div>
      @endforeach

      @foreach($inactivePackages as $purchase)
        @php
          $endDate = $purchase->validity ? \Carbon\Carbon::parse($purchase->validity) : \Carbon\Carbon::parse($purchase->created_at)->addDays($purchase->package->validity);
          $isExpired = now()->greaterThan($endDate);
          $nextSettlement = $purchase->date ? \Carbon\Carbon::parse($purchase->date) : \Carbon\Carbon::parse($purchase->created_at)->addHours(24);
          
          // Calculate actual daily income based on VIP level
          $dailyIncome = $purchase->package->daily_income;
          $vipCommissions = json_decode($purchase->package->vip_commission, true);
          
          if (is_array($vipCommissions) && count($vipCommissions) > 0) {
              $referralCount = auth()->user()->validDirectReferralsCount();
              // Find the highest tier met by the user
              foreach ($vipCommissions as $vc) {
                  if ($referralCount >= $vc['referrals']) {
                      $dailyIncome = $vc['income'];
                  }
              }
          }
        @endphp
        <div class="product-info inactive" style="display: none;">
          <div class="product-img">
            <img src="{{ asset($purchase->package->photo) }}" alt="Product Image: {{ $purchase->package->name }}">
          </div>
          <div class="product-text">
            <h3>{{ $purchase->package->name }}</h3>
            <p>Price: <span>{{ price($purchase->package->price )}} </span></p>
            <p>Cycle: <span>{{ $purchase->package->validity }} Days</span></p>
            <p>Daily Income: <span>{{ price($dailyIncome) }} </span></p>
            <p>Total Revenue: <span>{{ price($dailyIncome * $purchase->package->validity) }}</span></p>
            <p>Purchase Date: <span>{{ \Carbon\Carbon::parse($purchase->created_at)->format('M d, Y') }}</span></p>
            <p>End Date: <span>{{ $endDate->format('M d, Y') }}</span></p>
            <p>Next Settlement Time: <span class="settlement-time-expired">@if($isExpired)<strong>Expired</strong>@else{{ $nextSettlement->format('M d, Y H:i') }}@endif</span></p>
          </div>
        </div>
      @endforeach

      <p class="no-data" style="display: none;">No More Data.</p>
    </div>
  </div>

  <script>
    $(document).ready(function () {
      function toggleProducts(status) {
        if (status === 'active') {
          $('.product-info.active').show();
          $('.product-info.inactive').hide();
        } else {
          $('.product-info.active').hide();
          $('.product-info.inactive').show();
        }

        $('.no-data').toggle($('.product-info:visible').length === 0);
      }

      toggleProducts('active');

      $('.tab-link').on('click', function () {
        $('.tab-link').removeClass('active');
        $(this).addClass('active');
        toggleProducts($(this).data('status'));
      });
    });
  </script>
</body>
</html>