<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
  <title>Products</title>
  <link rel="icon" type="image/png" href="/static/img/images.png">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css"/>
  <!-- Global Color Scheme -->
  <link rel="stylesheet" href="{{asset('public/assets/global-colors.css')}}">
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background: #f4f6f9;
      margin: 0;
      padding: 0;
    }


    main {
      padding-bottom: 100px; /* Enough space for bottom menu */
    }

    .top-bar {
      display: flex;
      align-items: center;
      background: linear-gradient(to right, #004831, #003d28); /* IDG Capital Green */
      padding: 14px 16px;
      color: #fff;
      font-size: 18px;
      font-weight: bold;
      box-shadow: 0 2px 4px rgba(0,0,0,0.15);
      position: sticky;
      top: 0;
      z-index: 99;
    }

    .back-btn {
      text-decoration: none;
      color: #fff;
      font-size: 20px;
      margin-right: 12px;
    }

    .top-bar .title {
      flex-grow: 1;
      text-align: center;
      margin-right: 32px;
    }

    .tab-buttons {
      display: flex;
      gap: 10px;
      padding: 15px;
      background: #fff;
      position: sticky;
      top: 58px;
      z-index: 90;
      box-shadow: 0 2px 5px rgba(0,0,0,0.04);
    }

    .tab-buttons button {
      flex: 1;
      padding: 10px;
      font-size: 15px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      background: #ccc;
      color: #fff;
      transition: 0.3s;
    }

    .tab-buttons button.active {
      background: #004831; /* IDG Capital Green */
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }

    .product-tab {
      display: none;
      animation: fadeIn 0.3s ease;
    }

    .product-tab.active {
      display: block;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(5px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .product-box {
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.06);
      margin: 25px 15px 15px 15px; /* Adjusted margin */
      overflow: visible; /* Allow header to overlap */
      transition: transform 0.2s;
      position: relative; /* For header positioning */
    }

    .product-box:hover {
      transform: scale(1.01);
    }

    .product-box.discount {
      background: #fffce6;
      border: 1px solid #f4c430;
    }

    .product-box.soldout {
      opacity: 0.6;
      pointer-events: none;
    }

    .product-header {
      background: #004831; /* IDG Capital Green */
      color: #fff;
      padding: 10px 20px;
      font-weight: bold;
      position: absolute;
      top: -15px; /* Overlap effect */
      left: 50%;
      transform: translateX(-50%);
      width: 95%;
      border-radius: 20px; /* Pill shape */
      display: flex;
      justify-content: space-between;
      align-items: center;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      z-index: 2;
    }

    .badge {
      background: #A0C81E; /* Light green oval */
      color: black;
      padding: 4px 10px;
      font-size: 13px;
      border-radius: 20px; /* Oval shape */
      font-weight: 600;
      white-space: nowrap;
    }

    .product-body {
      padding: 15px;
      padding-top: 40px; /* Push content down */
    }

    .product-content {
      display: flex;
      gap: 12px;
    }

    .product-left img {
      width: 85px;
      height: 85px;
      object-fit: cover;
      border-radius: 8px;
    }

    .product-info {
      flex: 1;
      font-size: 14px;
      color: #333;
    }

    .product-info p {
      margin: 6px 0;
      display: flex;
      justify-content: space-between;
    }

    .product-info span {
      color: #004831; /* IDG Capital Green */
      font-weight: 600;
    }

    .product-footer {
      margin-top: 10px;
      display: flex;
      justify-content: space-between;
      flex-wrap: wrap;
      align-items: center;
    }

    .price-discount {
      font-size: 14px;
    }

    .original-price {
      text-decoration: line-through;
      color: #888;
    }

    .discounted-price {
      color: red;
      font-weight: bold;
    }

    .countdown {
      font-size: 12px;
      color: #666;
      margin-top: 5px;
    }

    .rent-btn {
      background: #A0C81E; /* IDG Capital Button Green */
      color: #000000;
      padding: 6px 15px;
      border-radius: 20px;
      text-decoration: none;
      transition: 0.3s;
    }

    .rent-btn:hover {
      background: #8fb01a; /* Darker shade on hover */
    }

    .rent-btn.disabled {
      background: #222;
      pointer-events: none;
    }

    .no-more {
      text-align: center;
      color: #888;
      margin: 25px 0 5px;
      font-size: 14px;
    }
  </style>
</head>
<body>

  <div class="top-bar">
    <a href="javascript:history.back()" class="back-btn">←</a>
    <div class="title"> Investment Packages</div>
  </div>

  <div class="desc" style="background:#fff; margin: 15px; padding: 15px; border-radius: 12px; border-left: 4px solid #004831; box-shadow: 0 2px 8px rgba(0,0,0,0.04);">
    <ul style="padding-left: 20px; margin: 0; color: #666; font-size: 14px;">
        <li>রেফারেল নিদিষ্ট পরিমান অর্থ বিনিয়োগ করলে কার্যকর হবে</li>
        <li>টেলিগ্রাম গ্রুপে জয়েন হওয়ার জন্য ইনভেস্ট করা লাগবে</li>
    </ul>
  </div>

  <main>
    @php
      use App\Models\Package;
      $packages = Package::where('status', 'active')->orderBy('display_order', 'asc')->get()->groupBy('type');
    @endphp

    <!-- Tabs -->
    <div class="tab-buttons">
      <button class="active" onclick="showTab(event, 'fixed')">Basic</button>
      <button onclick="showTab(event, 'welfare')">Standard</button>
      <button onclick="showTab(event, 'activity')">Premium</button>
    </div>

    @foreach(['fixed', 'welfare', 'activity'] as $cat)
      <div class="product-tab {{ $loop->first ? 'active' : '' }}" id="{{ $cat }}">
        @foreach ($packages[$cat] ?? [] as $package)
          @php
            $isDiscounted = $package->discount_percentage > 0;
            $dailyIncome = round($package->commission_with_avg_amount / $package->validity, 2);
            
            // Check for VIP Commission tiers
            $vipCommissions = json_decode($package->vip_commission, true);
            $hasVipTiers = is_array($vipCommissions) && count($vipCommissions) > 0;
            
            if ($hasVipTiers) {
                // Get min and max income from VIP tiers
                $incomes = array_column($vipCommissions, 'income');
                $minIncome = min($incomes);
                $maxIncome = max($incomes);
            }
            // Calculate current purchase count for this user
            $currentPurchaseCount = \App\Models\Purchase::where('user_id', auth()->id())
                ->where('package_id', $package->id)
                ->where('status', 'active')
                ->count();
            // Set buy limit using same logic as ProductController
            $buyLimit = $package->buy_limit ?? ($package->price > 0 ? 2 : 1);
          @endphp
          <div class="product-box {{ $isDiscounted ? 'discount' : '' }} {{ $package->is_sold_out ? 'soldout' : '' }}">
            <div class="product-header">
              {{ $package->name }}
              <span class="badge">{{ $currentPurchaseCount }}/{{ $buyLimit }}</span>
            </div>
            <div class="product-body">
              <div class="product-content">
                <div class="product-left">
                  <img src="{{ $package->photo }}" alt="{{ $package->name }}">
                </div>
                <div class="product-info">
                  <p>Purchase price: <span>{{ price($package->price) }} </span></p>
                  <p>Validity: <span>{{ $package->validity }} Days</span></p>
                  <p>Daily Profit: 
                    <span>
                      @if($package->price > 0)
                        @if($hasVipTiers)
                            {{ round(($minIncome / $package->price) * 100, 2) }}% ~ {{ round(($maxIncome / $package->price) * 100, 2) }}%
                        @else
                            {{ round(($dailyIncome / $package->price) * 100, 2) }}%
                        @endif
                      @else
                        0%
                      @endif
                    </span>
                  </p>
                  <p>Daily Income: 
                    <span>
                      @if($hasVipTiers)
                        {{ price($minIncome) }} ~ {{ price($maxIncome) }}
                      @else
                        {{ price($dailyIncome) }}
                      @endif
                    </span>
                  </p>
                  <p>Revenue: 
                    <span>
                      @if($hasVipTiers)
                        {{ price($minIncome * $package->validity) }} ~ {{ price($maxIncome * $package->validity) }}
                      @else
                        {{ price($package->commission_with_avg_amount) }}
                      @endif
                    </span>
                  </p>
                </div>
              </div>
              <div class="product-footer">
                <div class="price-discount">
                  @if($isDiscounted)
                    <span class="original-price">{{ price($package->price) }} </span>
                    <span class="discounted-price">{{ price($package->discounted_price) }} </span>
                  @else
                    <span class="discounted-price">{{ price($package->price) }}</span>
                  @endif
                  @if($package->show_timer)
                    <div class="countdown" data-end="{{ now()->addDays(1)->toIso8601String() }}"></div>
                  @endif
                </div>
                <a href="{{ route('product.detail', ['id' => $package->id]) }}"
                   class="rent-btn {{ $package->is_sold_out ? 'disabled' : '' }}">
                  {{ $package->is_sold_out ? 'Sold Out' : 'Invest Now' }}
                </a>
              </div>
            </div>
          </div>
        @endforeach
      </div>
    @endforeach

    <div class="no-more">— No more —</div>
  </main>

  @include('app.layout.manu')

  <script>
    function showTab(evt, tabId) {
      document.querySelectorAll('.product-tab').forEach(tab => tab.classList.remove('active'));
      document.querySelectorAll('.tab-buttons button').forEach(btn => btn.classList.remove('active'));
      document.getElementById(tabId).classList.add('active');
      evt.target.classList.add('active');
    }

    function updateCountdowns() {
      const now = new Date();
      document.querySelectorAll('.countdown').forEach(el => {
        const end = new Date(el.getAttribute('data-end'));
        const diff = end - now;
        if (diff > 0) {
          const d = Math.floor(diff / (1000 * 60 * 60 * 24));
          const h = Math.floor((diff / (1000 * 60 * 60)) % 24);
          const m = Math.floor((diff / (1000 * 60)) % 60);
          const s = Math.floor((diff / 1000) % 60);
          el.textContent = `⏳ ${d}d ${h}h ${m}m ${s}s`;
        } else {
          el.textContent = '⏰ Expired';
        }
      });
    }

    setInterval(updateCountdowns, 1000);
    updateCountdowns();
  </script>

</body>
</html>

