<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Product Detail</title>
  <link rel="icon" type="image/png" href="/static/img/images.png">
  <style>
    body {
      margin: 0;
      padding: 0;
      font-family: 'Segoe UI', Tahoma, sans-serif;
      background-color: #f4f6f8;
      color: #333;
    }

    .header {
      background: linear-gradient(to right, #004831, #003d28);
      color: white;
      text-align: center;
      padding: 15px;
      font-size: 22px;
      font-weight: bold;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    }

    .product-image {
      width: 100%;
      height: 220px;
      object-fit: cover;
      border-bottom: 4px solid #004831;
    }

    .product-box {
      background-color: white;
      padding: 20px;
      margin: 16px;
      border-radius: 12px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.05);
      position: relative;
    }

    .badge {
      background: #A0C81E;
      color: #000;
      font-size: 12px;
      padding: 5px 10px;
      border-radius: 8px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.15);
      white-space: nowrap;
    }

    .product-title-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 18px;
    }

    .product-title {
      font-size: 24px;
      font-weight: bold;
      color: #222;
      margin: 0;
    }

    .stats-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 12px;
    }

    .stat-box {
      background: #f9fafb;
      padding: 12px;
      border-radius: 10px;
      text-align: center;
      border: 1px solid #eee;
    }

    .stat-label {
      font-size: 13px;
      color: #777;
    }

    .stat-value {
      font-size: 17px;
      font-weight: bold;
      color: #004831;
      margin-top: 5px;
    }

    .original-price {
      text-decoration: line-through;
      color: #888;
      font-size: 13px;
      margin-right: 5px;
    }

    .discounted-price {
      color: red;
      font-weight: bold;
    }

    .desc {
      background-color: #fff;
      margin: 16px;
      padding: 16px;
      border-radius: 12px;
      font-size: 15px;
      line-height: 1.7;
      color: #444;
      box-shadow: 0 2px 8px rgba(0,0,0,0.04);
    }

    .rent-btn {
      background: #A0C81E;
      color: #000000;
      padding: 14px;
      width: 92%;
      margin: 20px auto 80px;
      display: block;
      text-align: center;
      font-size: 18px;
      font-weight: bold;
      border: none;
      border-radius: 30px;
      cursor: pointer;
      transition: background 0.3s ease, transform 0.2s ease;
    }

    .rent-btn:hover {
      background: #8fb01a;
      transform: scale(1.02);
    }

    .balance-bar {
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      background-color: #fff;
      border-top: 1px solid #ddd;
      padding: 12px 15px;
      font-size: 15px;
      color: #333;
      display: flex;
      justify-content: space-between;
      box-shadow: 0 -2px 6px rgba(0,0,0,0.03);
      z-index: 10000;
    }

    .balance-bar strong {
      color: #004831;
    }

    /* Modal */
    .rental-modal {
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      background: #fff;
      border-top-left-radius: 20px;
      border-top-right-radius: 20px;
      box-shadow: 0 -2px 10px rgba(0,0,0,0.2);
      z-index: 9999;
      display: none;
      padding: 20px;
      animation: slideUp 0.3s ease-out;
    }

    @keyframes slideUp {
      from { transform: translateY(100%); }
      to { transform: translateY(0); }
    }

    .modal-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      border-bottom: 1px solid #eee;
      margin-bottom: 10px;
    }

    .modal-header h3 {
      margin: 0;
      font-size: 18px;
    }

    .close-btn {
      background: none;
      border: none;
      font-size: 20px;
      cursor: pointer;
    }

    .balance-section p,
    .rental-info p {
      margin: 8px 0;
      font-size: 14px;
    }

    .wallet-select label {
      display: block;
      margin: 10px 0;
      font-size: 15px;
    }

    .wallet-select input {
      margin-right: 8px;
    }

    .modal-actions {
      display: flex;
      justify-content: space-between;
      margin-top: 20px;
    }

    .modal-actions button {
      flex: 1;
      margin: 0 5px;
      padding: 12px;
      border: none;
      border-radius: 10px;
      font-weight: bold;
      cursor: pointer;
      font-size: 16px;
    }

    .modal-actions button:first-child {
      background: #28a745;
      color: white;
    }

    .modal-actions button:last-child {
      background: #dc3545;
      color: white;
    }
  </style>
</head>



<body>
  

  <div class="header">Income Structure</div>
  

  <!-- Product Image Hidden -->
  <!-- <img src="{{ $package->photo }}" alt="{{ $package->name }}" class="product-image"> -->

  <div class="product-box">
    @php
      // Calculate current purchase count for this user
      $currentPurchaseCount = \App\Models\Purchase::where('user_id', auth()->id())
          ->where('package_id', $package->id)
          ->where('status', 'active')
          ->count();
      // Set buy limit using same logic as ProductController
      $buyLimit = $package->buy_limit ?? ($package->price > 0 ? 2 : 1);
    @endphp
    <div class="product-title-header">
      <div class="product-title">{{ $package->name }}</div>
      <span class="badge">{{ $currentPurchaseCount }}/{{ $buyLimit }}</span>
    </div>

    <div class="stats-grid">
      <div class="stat-box">
        <div class="stat-label">Purchase Price</div>
        <div class="stat-value">
            @if($package->discount_percentage > 0)
                <span class="original-price">{{ price($package->price) }}</span>
                <br>
                <span class="discounted-price">{{ price($package->discounted_price) }}</span>
            @else
                {{ price($package->price) }}
            @endif
        </div>
      </div>
      <div class="stat-box">
        <div class="stat-label">Validity</div>
        <div class="stat-value">{{ $package->validity }} Days</div>
      </div>
    </div>
    @if($package->required_direct_referrals > 0)
      <div style="color: #ff0000; font-weight: bold; font-size: 14px; margin-top: 15px; text-align: center; background: #fff0f0; padding: 10px; border-radius: 8px; border: 1px solid #ffcccc;">
        <i class="bx bx-error-circle"></i> 
        You will need at least {{ $package->required_direct_referrals }} referrals to invest in this package.
      </div>
    @endif
  </div>

  <!--<div class="desc" style="margin-top: 0px; border-left: 4px solid #004831;">-->
  <!--  <ul style="padding-left: 20px; margin: 0; color: #666; font-size: 14px;">-->
  <!--      <li>রেফারেল নিদিষ্ট পরিমান অর্থ বিনিয়োগ করলে কার্যকর হবে</li>-->
  <!--      <li>টেলিগ্রাম গ্রুপে জয়েন হওয়ার জন্য ইনভেস্ট করা লাগবে</li>-->
  <!--  </ul>-->
  <!--</div>-->

  @php
    $vipCommissions = json_decode($package->vip_commission, true);
  @endphp

  @if($vipCommissions && count($vipCommissions) > 0)
  <style>
    .vip-table-container {
      margin: 16px;
      background: #fff; /* White background */
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 2px 8px rgba(0,0,0,0.04);
      border: 1px solid #eee;
    }
    .vip-table {
      width: 100%;
      border-collapse: collapse;
      text-align: center;
    }
    .vip-table th {
      background-color: #f1f3f5;
      padding: 12px;
      font-size: 14px;
      font-weight: bold;
      color: #333;
      border-bottom: 1px solid #eee;
    }
    .vip-table td {
      padding: 12px;
      border-bottom: 1px solid #eee;
      font-size: 14px;
      color: #555;
    }
    .vip-table tr:last-child td {
      border-bottom: none;
    }
    .vip-table tr:nth-child(even) {
      background-color: #fff;
    }
  </style>
  <div class="vip-table-container">
    <table class="vip-table">
      <thead>
        <tr>
          <th>Referrals</th>
          <th>Profit %</th>
          <th>Daily</th>
          <th>Total</th>
        </tr>
      </thead>
      <tbody>
        @foreach($vipCommissions as $vc)
        <tr>
          <td>{{ $vc['referrals'] ?? 0 }}+</td> 
          <td>{{ $package->price > 0 ? round(($vc['income'] / $package->price) * 100, 2) : 0 }}%</td>
          <td>{{ price($vc['income']) }}</td>
          <td>{{ price($vc['income'] * $package->validity) }}</td>
        </tr>
        @endforeach
      </tbody>
    </table>
  </div>
  @endif
  
  <form id="rental-form" action="{{ route('buy.package', ['id' => $package->id]) }}" method="POST">
        @csrf
  <button class="rent-btn" onclick="buyProduct('{{$package->id}}')">Invest Now</button>

  <div class="balance-bar">
    <div>Your Balance:<strong>           {{ price(auth()->user()->balance) }}</strong></div>
  </div>

  <!-- Rental Modal --
  <div id="rentalModal" class="rental-modal">
    <div class="modal-header">
      <h3>Confirm Rental</h3>
      <button class="close-btn" onclick="closeRentalModal()">✖</button>
    </div>

    <div class="balance-section">
      <p><strong>🔐 Main Wallet:</strong> {{ price(auth()->user()->balance) }}</p>
      <p><strong>🎁 Bonus Wallet:</strong> {{ price(auth()->user()->bonus_balance) }}</p>
    </div>

    <div class="rental-info">
      <p><strong>🐔 Product:</strong> LK6800 Chicken</p>
      <p><strong>💰 Price:</strong> {{ price(6800) }}</p>
      <p><strong>⏱ Duration:</strong> 42 days</p>
      <p><strong>📈 Profit:</strong> {{ price(356) }} / day</p>
    </div>

    <form id="rentalForm" method="POST" action="{{ url('user.rent.confirm') }}">
      @csrf
      <input type="hidden" name="product_id" value="6800">
      <input type="hidden" name="wallet_type" id="walletType">

      <div class="wallet-select">
        <label><input type="radio" name="wallet" value="main"> Use Main Wallet</label>
        <label><input type="radio" name="wallet" value="bonus"> Use Bonus Wallet</label>
      </div>

      <div class="modal-actions">
        <button type="button" onclick="submitRental()">✅ Confirm</button>
        <button type="button" onclick="closeRentalModal()">❌ Cancel</button>
      </div>-->
    </form>
  </div>
  @include('alert-message')
<script>
    function buyProduct(id){
  document.querySelector('.loading').style.display = 'block';
  window.location.href = "{{ url('purchase/confirmation') }}/" + id;
}
</script>

<script>
    function menuActive(_this, menuName){
        var elements = document.querySelectorAll('.typeitem');
        for (let i=0;i<elements.length;i++){
            if (elements[i].classList.contains('typeover')){
                elements[i].classList.remove('typeover')
            }
        }
        _this.classList.add('typeover')

        if (menuName == 'product'){
            document.getElementById('list').style.display='block';
            document.getElementById('mylist').style.display='none';
        }
        if (menuName == 'myproduct'){
            document.getElementById('list').style.display='none';
            document.getElementById('mylist').style.display='block';
        }
    }
</script>
</body>
</html>

  <!--<script>
    /*function openRentalModal() {
      document.getElementById('rentalModal').style.display = 'block';
    }

    function closeRentalModal() {
      document.getElementById('rentalModal').style.display = 'none';
    }*

    function submitRental() {
      //const selected = document.querySelector('input[name="wallet"]:checked');
      //if (!selected) {
        alert('Please select a wallet!');
        return;
      }
      document.getElementById('walletType').value = selected.value;
      document.getElementById('rentalForm').submit();
    }
  </script>
</body>
</html>-->
