<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Reward</title>
  <link rel="icon" type="image/png" href="/static/img/images.png">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * {
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f5f5f5;
      margin: 0;
      padding: 0;
    }

    .top-bar {
      display: flex;
      align-items: center;
      background-color: #004831;
      color: white;
      padding: 14px 16px;
      position: sticky;
      top: 0;
      z-index: 999;
    }

    .back-btn {
      text-decoration: none;
      color: white;
      font-size: 20px;
      margin-right: 16px;
    }

    .title {
      flex-grow: 1;
      text-align: center;
      font-size: 16px;
      margin-right: 32px;
      font-weight: bold;
    }

    .tab-content {
      padding: 20px;
    }

    .card {
      background: white;
      border-radius: 12px;
      box-shadow: 0 4px 8px rgba(0,0,0,0.1);
      padding: 16px;
      margin-bottom: 16px;
      border-top: 6px solid #004831;
    }

    .card h3 {
      margin: 0 0 10px;
      font-size: 16px;
      color: #fff;
      background: #004831;
      border-radius: 6px 6px 0 0;
      padding: 8px 12px;
    }

    .info-row {
      display: flex;
      justify-content: space-between;
      margin: 12px 0;
      text-align: center;
    }

    .info-box {
      flex: 1;
    }

    .info-box p {
      margin: 4px 0;
      color: #777;
      font-size: 13px;
    }

    .info-box .value {
      font-weight: bold;
      font-size: 18px;
      color: #333;
    }

    .progress-container {
      background: #d8dee3;
      border-radius: 12px;
      height: 12px;
      overflow: hidden;
      margin: 12px 0;
    }

    .progress-fill {
      height: 100%;
      background-color: #004831;
      width: 0;
      transition: width 0.4s ease;
    }

    .progress-text {
      text-align: center;
      font-size: 13px;
      color: #333;
      margin-top: 4px;
    }

    .footer {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-top: 8px;
    }

    .footer .amount {
      font-weight: bold;
      font-size: 16px;
    }

    .footer button {
      padding: 8px 16px;
      border: none;
      border-radius: 20px;
      font-weight: bold;
      cursor: pointer;
      transition: 0.3s;
    }

    .footer .claim-btn {
      background-color: #A0C81E;
      color: #000000;
    }

    .footer .disabled {
      background-color: #ccc;
      color: white;
      cursor: not-allowed;
    }

    .card:hover {
      transform: scale(1.01);
      transition: 0.2s ease-in-out;
    }
  </style>
</head>
<body>

<div class="top-bar">
  <a href="javascript:history.back()" class="back-btn">←</a>
  <div class="title">Reward</div>
</div>

<div id="monthly" class="tab-content active">

    @foreach ($monthly_salaries_list as $monthly_tier)
        <div class="card">
            <h3>Reward</h3>
            <div class="info-row">
                <div class="info-box">
                    <p>Valid Invite</p>
                    <p class="value">{{ $monthly_invite_count }}</p>
                </div>
                <div class="info-box">
                    <p>Completed</p>
                    <p class="value">{{ min($monthly_invite_count, $monthly_tier['required']) }}</p>
                </div>
                <div class="info-box">
                    <p>Reward Bonus</p>
                    <p class="value">৳{{ $monthly_tier['bonus'] }}</p>
                </div>
            </div>
            <div class="progress-container">
                @php
                    $target = $monthly_tier['required'];
                    $progress = $target > 0 ? min(100, intval(($monthly_invite_count / $target) * 100)) : 0;
                @endphp
                <div class="progress-fill" style="width: {{ $progress }}%;"></div>
            </div>
            <div class="progress-text">{{ min($monthly_invite_count, $target) }} / {{ $target }}</div>
            <div class="footer">
                <span class="amount">৳{{ $monthly_tier['bonus'] }}</span>
                
                @if ($monthly_salary >= $monthly_tier['bonus'] && !$monthly_salary_claimed)
                     <form method="POST" action="{{ route('reward.claim.monthly') }}">
                        @csrf
                        <button class="claim-btn">Get Bonus</button>
                    </form>
                @elseif($monthly_salary_claimed && $monthly_salary >= $monthly_tier['bonus'])
                     <button class="disabled">Has Been Get</button>
                @else
                    <button class="disabled">Not Yet</button>
                @endif

            </div>
        </div>
    @endforeach

</div>

@include('alert-message')
</body>
</html>