<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>Support</title>
    <link rel="icon" type="image/png" href="/static/img/images.png">
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            background-color: #f4f6f9;
        }
        .top {
            background: linear-gradient(to right, #004831, #003d28) !important;
            padding: 15px !important;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            color: #fff;
            height: 60px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .topLeft {
            position: absolute;
            left: 15px;
            color: #fff !important;
            font-size: 20px;
            text-decoration: none;
        }
        .topTit {
            font-size: 18px;
            font-weight: bold;
        }
        .customer {
            padding: 20px 15px;
        }
        .customer ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .customer ul li {
            background: #fff;
            border-radius: 12px;
            margin-bottom: 20px;
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            position: relative;
        }
        .customer ul li img {
            width: 50px;
            height: 50px;
            object-fit: contain;
        }
        .service-box-dl {
            flex: 1;
        }
        .service-box-dl h3 {
            font-size: 17px;
            font-weight: bold;
            color: #333;
            margin: 0 0 5px 0;
        }
        .service-box-dl h2 {
            font-size: 13px;
            color: #666;
            margin: 0;
            font-weight: normal;
        }
        .customer ul li a {
            background: #004831;
            color: #fff;
            padding: 8px 18px;
            border-radius: 20px;
            font-weight: bold;
            text-decoration: none;
            font-size: 14px;
            transition: 0.3s;
            box-shadow: 0 2px 6px rgba(0,72,49,0.3);
        }
        .customer ul li a:hover {
            background: #003d28;
            transform: scale(1.05);
        }
    </style>
</head>
<body class="homeColor">
<div class="top">
    <a href="javascript:history.back()" class="topLeft">
        <i class="fas fa-arrow-left"></i>
    </a>
    <div class="topTit">Online Service</div>
</div>
<div class="customer">
    <ul>
        @foreach($services as $service)
            <li>
                <img src="{{ $service->platform == 'telegram' ? asset('public/static/img/telegram.png') : asset('public/static/img/whatsapp.png') }}"
                     onerror="this.src='{{ $service->platform == 'telegram' ? 'https://upload.wikimedia.org/wikipedia/commons/8/82/Telegram_logo.svg' : 'https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg' }}'"
                     alt="">
                <div class="service-box-dl">
                    <h3>{{ $service->name }}</h3>
                    <h2 style="font-size: 11px; margin-top: 3px; color: #888;">{{ $service->description }}</h2>
                </div>
                <a href="{{ $service->link }}" target="_blank">GO</a>
            </li>
        @endforeach
    </ul>
</div>
</body>
</html>
