<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>Team</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="https://test.club4u.online/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <style>
        .team-section { display: none; }
        .team-section.active { display: block; }
        .inline-tab .cur { font-weight: bold; }
    </style>
<head>
    <style>
        /* Add styles for the loading message */
        .loading-message {
            display: none; /* Hidden by default */
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: white;
            border: 1px solid #ccc;
            padding: 20px;
            z-index: 1000;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body class="homeColor">
<div class="top">
    <div class="topTit">Team</div>
</div>
<div class="team-main">
    <div class="team-totalNum">
        <dl>
            <dt>Total Income</dt>
            <dd>{{price($levelTotalCommission1 + $levelTotalCommission2 + $levelTotalCommission3)}}</dd>
        </dl>
        <dl>
            <dt>Total Invitation</dt>
            <dd>{{$team_size}}</dd>
        </dl>
    </div>
    <div class="team-code">
        <div class="team-code-item">
            <div class="code-tit">Invitation Code</div>
            <div class="team-code-copy" data-clipboard-text="{{ auth()->user()->ref_id }}">
                <div class="team-code-input">{{auth()->user()->ref_id}}</div>
                <div class="copy" onclick="copyCode(this)">COPY</div>
            </div>
        </div>
        @php
    $referralLink = url('/account/register') . '?inviteCode=' . auth()->user()->ref_id;
@endphp
        <div class="team-code-item">
            <div class="team-code-left">
                <div class="code-tit">Invitation Link</div>
                <div class="team-code-copy" data-clipboard-text="{{ $referralLink }}">
                    <div class="team-code-input">{{ $referralLink }}</div>
                    <div class="copy" onclick="copyCode(this)">COPY</div>
                </div>
            </div>
        </div>
    </div>

@php
    // Fetch the rebate values for each team level
    $rebate1 = \App\Models\Rebate::sum('interest_commission1');
    $rebate2 = \App\Models\Rebate::sum('interest_commission2');
    $rebate3 = \App\Models\Rebate::sum('interest_commission3');
@endphp

<div class="team-record">
    <div class="inline-tab">
        <a href="#" class="tab cur" data-team="teamB" onclick="showTeam('teamB')">Team B<i></i></a>
        <a href="#" class="tab" data-team="teamC" onclick="showTeam('teamC')">Team C<i></i></a>
        <a href="#" class="tab" data-team="teamD" onclick="showTeam('teamD')">Team D<i></i></a>
    </div>

    <div id="teamB-summary" class="team-summary active">
        <ul>
            <li><h3>{{$first_level_users->count()}}</h3><p>Total Invite</p></li>
            <li><h3>{{$first_level_users->where('investor', 1)->count()}}</h3><p>Valid Invite</p></li>
            <li><h3>{{ $levelTotalCommission1 }}</h3><p>Total Income</p></li>
            <li><h3>{{ $rebate1 }}</h3><p>Team Profit</p></li>
        </ul>
    </div>

    <div id="teamC-summary" class="team-summary">
        <ul>
            <li><h3>{{$second_level_users->count()}}</h3><p>Total Invite</p></li>
            <li><h3>{{$second_level_users->where('investor', 1)->count()}}</h3><p>Valid Invite</p></li>
            <li><h3>{{ $levelTotalCommission2 }}</h3><p>Total Income</p></li>
            <li><h3>{{ $rebate2 }}</h3><p>Team Profit</p></li>
        </ul>
    </div>

    <div id="teamD-summary" class="team-summary">
        <ul>
            <li><h3>{{$third_level_users->count()}}</h3><p>Total Invite</p></li>
            <li><h3>{{$third_level_users->where('investor', 1)->count()}}</h3><p>Valid Invite</p></li>
            <li><h3>{{ $levelTotalCommission3 }}</h3><p>Total Income</p></li>
            <li><h3>{{ $rebate3 }}</h3><p>Team Profit</p></li>
        </ul>
    </div>
</div>

<div class="teamList">
    <table>
        <thead>
            <tr>
                <td>Account</td>
                <td>Referrer</td>
                <td>Max</td>
            </tr>
        </thead>

        <tbody id="teamB" class="team-users active">
            @foreach($first_level_users as $user)
                <tr>
                    <td>{{ $user->phone }}</td>
                    <td>{{ $user->referrer ? $user->referrer->phone : 'N/A' }}</td>
                    <td>{{ $first_level_users->count() }}</td>
                </tr>
            @endforeach
        </tbody>

        <tbody id="teamC" class="team-users ">
            @foreach($second_level_users as $user)
                <tr>
                    <td>{{ $user->phone }}</td>
                    <td>{{ $user->referrer ? $user->referrer->phone : 'N/A' }}</td>
                    <td>{{ $second_level_users->count() }}</td>
                </tr>
            @endforeach
        </tbody>

        <tbody id="teamD" class="team-users">
            @foreach($third_level_users as $user)
                <tr>
                    <td>{{ $user->phone }}</td>
                    <td>{{ $user->referrer ? $user->referrer->phone : 'N/A' }}</td>
                    <td>{{ $third_level_users->count() }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<style>

    .team-summary, .team-users {
        display: none;
    }

    .team-summary.active, .team-users.active {
        display: block;
    }
</style>

<script>
    function showTeam(team) {

        document.querySelectorAll('.tab').forEach(tab => tab.classList.remove('cur'));
        document.querySelectorAll('.team-summary, .team-users').forEach(section => section.classList.remove('active'));

        document.querySelector(`.tab[data-team="${team}"]`).classList.add('cur');
        document.getElementById(`${team}-summary`).classList.add('active');
        document.getElementById(team).classList.add('active');
    }
</script>
