<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Forgot Password - Request OTP</title>
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
</head>
<body class="bgColor">
    <div class="top">
        <a href="" class="topLeft">
            <i class="layui-icon layui-icon-left"></i>
        </a>
        <div class="topTit">Forgot Password</div>
    </div>
    <div class="warp">
        <div class="login-head">
            <img src="{{ asset('public/static/img/logo.b086b4ea.png') }}" alt="Logo">
        </div>
        <div class="login">
            <div class="loginCon">
                <form action="{{ url('/password/request-otp') }}" method="POST" class="register-form">
                    @csrf
                    <div class="circlebg">
                        <input type="text" name="phone" placeholder="Enter Phone Number" required>
                    </div>
                    <div class="circlebg otp-container">
                        <input type="text" name="otp" placeholder="Enter OTP" required>
                        <button type="button" onclick="getOtp()" id="otpBtn" class="otpBtn login-main-otp-btn">Send OTP</button>
                        <span id="countdown" style="margin-left: 10px; color: #555;"></span>
                    </div>
                    <div class="continue">
                        <button type="submit" class="add-btn login-btn">Request OTP</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="/static/jquery-3.5.1.min.js"></script>
    <script>
        let timer;
        function startCountdown(duration, display) {
            let countdown = duration, minutes, seconds;
            timer = setInterval(function () {
                minutes = parseInt(countdown / 60, 10);
                seconds = parseInt(countdown % 60, 10);

                minutes = minutes < 05 ? "0" + minutes : minutes;
                seconds = seconds < 05 ? "0" + seconds : seconds;

                display.textContent = `${minutes}:${seconds}`;

                if (--countdown < 0) {
                    clearInterval(timer);
                    display.textContent = '';
                    document.getElementById("otpBtn").disabled = false;
                }
            }, 1000);
        }

        function getOtp() {
            document.getElementById("otpBtn").disabled = true;
            startCountdown(60, document.querySelector('#countdown'));

            // Make an AJAX request to send OTP to the entered phone number
            $.ajax({
                url: "{{ url('/password/send-otp') }}",
                method: "POST",
                data: {
                    _token: "{{ csrf_token() }}",
                    phone: $("input[name='phone']").val()
                },
                success: function(response) {
                    alert(response.message);  // Display a success message or handle errors as needed
                },
                error: function(error) {
                    alert("Error sending OTP. Please try again.");
                    clearInterval(timer);
                    document.getElementById("otpBtn").disabled = false;
                    document.getElementById("countdown").textContent = '';
                }
            });
        }
    </script>
</body>
</html>
