<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>SMBC | VIP Levels</title>
    <link rel="icon" type="image/png" href="/static/img/images.png">
    <link rel="stylesheet" href="/static/reset.css?v={{ time() }}"/>
    <link rel="stylesheet" href="/static/style.css?v={{ time() }}"/>
    <link rel="stylesheet" href="/static/layui.css?v={{ time() }}"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css" />
    <style>
        body {
            background-color: #ffffff !important; /* Clean white background */
            color: #000;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding-bottom: 80px; /* Space for bottom nav */
        }
        .vip-container {
            padding: 15px;
            max-width: 800px;
            margin: 0 auto;
            background-color: #ffffff;
        }
        .vip-header {
            text-align: center;
            margin-bottom: 25px;
            margin-top: 20px;
        }
        .vip-header h3 {
            color: #1a1a1a;
            font-weight: 700;
            border-bottom: 3px solid #28a745;
            display: inline-block;
            padding-bottom: 8px;
            font-size: 22px;
            letter-spacing: 0.5px;
        }
        .vip-table {
            width: 100%
;
            border-collapse: collapse;
            margin-bottom: 25px;
            font-size: 11px;
            text-align: center;
            background-color: #fff;
            color: #000;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .vip-table th {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: #ffffff;
            padding: 12px 4px;
            font-weight: 600;
            border: none;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 10px;
        }
        .vip-table td {
            padding: 10px 4px;
            border: 1px solid #e0e0e0;
            color: #333;
            font-weight: 500;
        }
        .vip-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .vip-table tr:hover {
            background-color: #e8f5e9;
            transition: background-color 0.3s ease;
        }
        
        .info-box {
            background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
            color: #000;
            padding: 18px;
            border-radius: 12px;
            margin-bottom: 25px;
            border-left: 4px solid #28a745;
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
        }
        .info-box strong {
            color: #28a745;
            font-size: 15px;
        }
        .info-box ul {
            padding-left: 20px;
            margin: 10px 0 0 0;
        }
        .info-box li {
            margin-bottom: 8px;
            font-size: 13px;
            color: #444;
            line-height: 1.6;
        }
        
        .section-title {
            color: #1a1a1a;
            font-size: 17px;
            font-weight: 700;
            margin-top: 25px;
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            padding-bottom: 8px;
            border-bottom: 2px solid #e0e0e0;
        }
        .section-title::before {
            content: '♦';
            color: #28a745;
            margin-right: 8px;
            font-size: 20px;
        }

        .level-list {
            font-size: 13px;
            line-height: 1.8;
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
        }
        .level-item {
            color: #28a745;
            font-weight: 700;
            font-size: 14px;
        }
        .level-desc {
            color: #555;
        }

        .tips-title {
            color: #dc3545;
            font-weight: 700;
            margin-top: 25px;
            margin-bottom: 12px;
            font-size: 16px;
        }
        .tips-text {
            font-size: 13px;
            color: #444;
            line-height: 1.7;
            background-color: #fff3cd;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #ffc107;
        }

        .reward-table {
            width: 100%;
            margin-top: 15px;
            border-collapse: collapse;
            color: #000;
            text-align: center;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border-radius: 8px;
            overflow: hidden;
        }
        .reward-table th, .reward-table td {
            border: 1px solid #e0e0e0;
            padding: 12px;
        }
        .reward-table th {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: #ffffff;
            font-weight: 600;
        }
        .reward-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .reward-table tr:hover {
            background-color: #e8f5e9;
        }
        
        .highlight-green {
            color: #28a745;
            font-weight: 700;
            margin-top: 20px;
            font-size: 14px;
            background-color: #d4edda;
            padding: 12px;
            border-radius: 8px;
            border-left: 4px solid #28a745;
        }

        /* Top Bar */
        .top-bar {
            background: linear-gradient(135deg, #004831, #003d28); /* IDG Capital Green */
            padding: 16px;
            color: #fff;
            display: flex;
            align-items: center;
            justify-content: center; /* Center the title */
            position: relative;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .top-bar .back-btn {
            color: white;
            font-size: 20px;
            position: absolute; /* Absolute position to not affect centering */
            left: 16px;
            text-decoration: none;
            transition: opacity 0.3s;
        }
        .top-bar .back-btn:hover {
            opacity: 0.8;
        }
        .top-bar .title {
            font-size: 18px;
            font-weight: 700;
            letter-spacing: 0.5px;
        }
        
        /* Additional styling for better readability */
        p {
            color: #444;
            line-height: 1.6;
        }
        
        h3 {
            color: #1a1a1a;
        }
    </style>
</head>
<body>

    <div class="top-bar">
        <a href="javascript:history.back()" class="back-btn">
            <i class="layui-icon layui-icon-left"></i> Back
        </a>
        <div class="title">VIP Details</div>
    </div>

    <div class="vip-container">
        <div class="vip-header">
            <h3>SMBC বিভিন্ন স্তরের পরিচিতি</h3>
        </div>

        <!-- Main Table -->
        <table class="vip-table">
            <thead>
                <tr>
                    <th>স্তর</th>
                    <th>মানুষের সংখ্যা</th>
                    <th>বিনিয়োগের পরিমাণ</th>
                    <th>প্রতিদিনের বৈধ ও স্বচ্ছ আয়ের রিটার্ন হার</th>
                    <th>প্রতিদিনের বৈধ ও স্বচ্ছ প্রকৃত আয়ের পরিমাণ</th>
                </tr>
            </thead>
            <tbody>
                <tr><td>S0</td><td>0</td><td>১০০০-১০,০০০</td><td>২.০%</td><td>২০-২০০</td></tr>
                <tr><td>S1</td><td>৩</td><td>২০০০-২০,০০০</td><td>২.৫%</td><td>৫০-৫০০</td></tr>
                <tr><td>S2</td><td>৬</td><td>৫০০০-৫০,০০০</td><td>৩.০%</td><td>১৫০-১৫০০</td></tr>
                <tr><td>S3</td><td>১২</td><td>১০,০০০-১০০,০০০</td><td>৩.৫%</td><td>৩৫০-৩৫০০</td></tr>
                <tr><td>S4</td><td>২০</td><td>২০,০০০-২০০,০০০</td><td>৪.০%</td><td>৮০০-৮০০০</td></tr>
                <tr><td>S5</td><td>৫০</td><td>৩০,০০০-৩০০,০০০</td><td>৪.৫%</td><td>১৩৫০-১৩,৫০০</td></tr>
                <tr><td>S6</td><td>৮০</td><td>৫০,০০০-৫০০,০০০</td><td>৫.০%</td><td>২৫০০-২৫,০০০</td></tr>
                <tr><td>S7</td><td>১২০</td><td>৬০,০০০-৬০০,০০০</td><td>৫.৫%</td><td>৩৩০০-৩৩,০০০</td></tr>
                <tr><td>S8</td><td>১৫০</td><td>৮০,০০০-৮০০,০০০</td><td>৬.০%</td><td>৪৮০০-৪৮,০০০</td></tr>
                <tr><td>S9</td><td>২০০</td><td>১০০,০০০-১,০০০,০০০</td><td>৭.০%</td><td>৭০০০-৭০,০০০</td></tr>
                <tr><td>S10</td><td>৩০০</td><td>১৫০,০০০-১,৫০০,০০০</td><td>৮.০%</td><td>১২,০০০-১২০,০০০</td></tr>
            </tbody>
        </table>

        <!-- Info Box -->
        <div class="info-box">
            <strong>দয়া করে মনে রাখুন:</strong>
            <ul>
                <li>আপনার অ্যাকাউন্টর স্তর উন্নীত করতে হলে, আপনাকে নতুন সদস্যকে আমন্ত্রণ জানিয়ে তাদের প্রথম রিচার্জ সম্পন্ন করাতে হবে।</li>
                <li>এবং নতুন সদস্যের প্রথম রিচার্জের পরিমাণ অবশ্যই আপনার নিজের প্রথম রিচার্জের পরিমাণের চেয়ে কম হওয়া চলবে না।</li>
            </ul>
        </div>

        <p style="font-size: 13px; color: #444; line-height: 1.6;">
            প্ল্যাটফর্মে সরাসরি সদস্যদের আমন্ত্রণ জানিয়ে আপনি আপনার অ্যাকাউন্ট লেভেল আপগ্রেড করতে পারেন। প্রতিটি আপগ্রেডের সাথে সম্পর্কিত সরাসরি সদস্যের আমন্ত্রণের সংখ্যা নিম্নরূপ:
        </p>

        <!-- Upgrade Levels -->
        <div class="section-title">অ্যাকাউন্ট আপগ্রেড মান:</div>
        <div class="level-list">
            <div><span class="level-item">S1:</span> <span class="level-desc">৩ জন সরাসরি অধস্তন রিচার্জ সদস্যকে আমন্ত্রণ জানান</span></div>
            <div><span class="level-item">S2:</span> <span class="level-desc">৬ জন সরাসরি অধস্তন রিচার্জ সদস্যকে আমন্ত্রণ জানান</span></div>
            <div><span class="level-item">S3:</span> <span class="level-desc">১২ জন সরাসরি অধস্তন রিচার্জ সদস্যকে আমন্ত্রণ জানান</span></div>
            <div><span class="level-item">S4:</span> <span class="level-desc">২০ জন সরাসরি অধস্তন রিচার্জ সদস্যকে আমন্ত্রণ জানান</span></div>
            <div><span class="level-item">S5:</span> <span class="level-desc">৫০ জন সরাসরি অধস্তন রিচার্জ সদস্যকে আমন্ত্রণ জানান</span></div>
            <div><span class="level-item">S6:</span> <span class="level-desc">৮০ জন সরাসরি অধস্তন রিচার্জ সদস্যকে আমন্ত্রণ জানান</span></div>
            <div><span class="level-item">S7:</span> <span class="level-desc">১২০ জন সরাসরি অধস্তন রিচার্জ সদস্যকে আমন্ত্রণ জানান</span></div>
            <div><span class="level-item">S8:</span> <span class="level-desc">১৫০ জন সরাসরি অধস্তন রিচার্জ সদস্যকে আমন্ত্রণ জানান</span></div>
            <div><span class="level-item">S9:</span> <span class="level-desc">২০০ জন সরাসরি অধস্তন রিচার্জ সদস্যকে আমন্ত্রণ জানান</span></div>
            <div><span class="level-item">S10:</span> <span class="level-desc">৩০০ জন সরাসরি অধস্তন রিচার্জ সদস্যকে আমন্ত্রণ জানান</span></div>
        </div>

        <!-- Tips -->
        <div class="tips-title">📌 গুরুত্বপূর্ণ টিপস:</div>
        <p class="tips-text">
            অধস্তন সদস্যদের প্রথম রিচার্জের পরিমাণ আপনার প্রথম রিচার্জের পরিমাণের চেয়ে কম হতে পারে না।
            <br><br>
            S0-স্তরের ব্যবহারকারীদের প্রথম রিচার্জ ফ্রিজ করা হবে। S1 স্তরে আপগ্রেড করার পর, তহবিলের সীমা স্বয়ংক্রিয়ভাবে উঠে যাবে এবং আপনি যথারীতি উপার্জন এবং উত্তোলনের সুবিধা উপভোগ করতে পারবেন।
        </p>
        
        <p class="highlight-green">
            ✅ সুযোগটি কাজে লাগান, দ্রুত এগিয়ে যান এবং আরও প্ল্যাটফর্ম সুবিধা এবং টিম সুবিধা আনলক করুন!
        </p>

        <!-- Upgrade Rewards Section -->
        <div style="text-align: center; margin-top: 30px;">
            <h3 style="color: #28a745; border-bottom: 3px solid #28a745; display: inline-block; padding-bottom: 8px; font-weight: 700;">আপগ্রেড পুরস্কার</h3>
            <p style="font-size: 13px; color: #555; margin-top: 15px; line-height: 1.6;">ব্যবহারকারীদের তাদের অ্যাকাউন্ট লেভেল আপগ্রেড করতে উৎসাহিত করার জন্য, SMBC অ্যাকাউন্ট লেভেল আপগ্রেড পুরস্কার এবং সুবিধা চালু করার সিদ্ধান্ত নিয়েছে</p>
        </div>

        <table class="reward-table">
            <tr><td>S1 লেভেল পুরস্কার</td><td>100 BDT</td></tr>
            <tr><td>S2 লেভেল পুরস্কার</td><td>200 BDT</td></tr>
            <tr><td>S3 লেভেল পুরস্কার</td><td>300 BDT</td></tr>
            <tr><td>S4 লেভেল পুরস্কার</td><td>500 BDT</td></tr>
            <tr><td>S5 লেভেল পুরস্কার</td><td>1,000 BDT</td></tr>
            <tr><td>S6 লেভেল পুরস্কার</td><td>2,000 BDT</td></tr>
            <tr><td>S7 লেভেল পুরস্কার</td><td>5,000 BDT</td></tr>
            <tr><td>S8 লেভেল পুরস্কার</td><td>10,000 BDT</td></tr>
            <tr><td>S9 লেভেল পুরস্কার</td><td>20,000 BDT</td></tr>
            <tr><td>S10 লেভেল পুরস্কার</td><td>50,000 BDT</td></tr>
        </table>

        <div style="margin-top: 25px; font-size: 13px; color: #555; text-align: center; background-color: #f8f9fa; padding: 20px; border-radius: 10px;">
            <p style="line-height: 1.6; margin-bottom: 12px;">তোমার SMBC র‍্যাঙ্ক বাড়াও এবং পুরস্কার অর্জন করো। এটা ভাগ্য নয়—এটা কঠোর পরিশ্রম এবং দৃঢ়তার ফল! যারা তাদের কর্মকাণ্ড দিয়ে প্রমাণ করেছে যে কঠোর পরিশ্রম সবসময়ই ফল দেয়।</p>
            <p style="color: #28a745; font-weight: 700; font-size: 14px; margin-bottom: 12px;">অপেক্ষা করো না—তুমিও পরবর্তী গৌরবের উত্থান ঘটাতে পারো!</p>
            <p style="line-height: 1.6;">স্বপ্ন অপেক্ষা করে না; সুযোগ তাদের কাছে আসে যারা প্রস্তুত থাকে</p>
        </div>

    </div>

    @include('app.layout.manu')

</body>
</html>
