<!DOCTYPE html>
<html lang="en">
<head>
 <!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-T3XGKYQQNJ"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-T3XGKYQQNJ');
</script>
  
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Login</title>
  <link rel="icon" type="image/png" href="/static/img/images.png">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css" />
  <!-- Global Color Scheme -->
  <link rel="stylesheet" href="<?php echo e(asset('public/assets/global-colors.css')); ?>">
  <style>
    :root {
      --primary: #004831;
      --primary-dark: #003d28;
      --button: #A0C81E;
      --gray: #888;
      --white: #fff;
    }

    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: var(--primary);
      color: var(--gray);
    }

    .container {
      max-width: 420px;
      margin: 40px auto;
      background-color: var(--white);
      border-radius: 32px 32px 0 0;
      padding: 24px;
    }

    .logo {
      text-align: center;
      margin-top: -20px;
    }

    .logo img {
      height: 60px;
      margin-bottom: 10px;
    }

    .tab-switch {
      display: flex;
      justify-content: space-around;
      border-radius: 32px 32px 0 0;
      background: var(--primary-dark);
    }

    .tab-switch div {
      flex: 1;
      text-align: center;
      padding: 14px 0;
      font-weight: bold;
      color: white;
      cursor: pointer;
      border-bottom: 3px solid transparent;
    }

    .tab-switch .active {
      background-color: var(--white);
      color: var(--primary);
      border-bottom: 3px solid var(--primary);
      border-radius: 32px 32px 0 0;
    }

    .form-title {
      text-align: center;
      font-size: 22px;
      font-weight: bold;
      color: var(--primary);
      margin: 20px 0;
    }

    .input-group {
      margin-bottom: 18px;
      position: relative;
    }

    .input-label {
      font-size: 14px;
      margin-bottom: 6px;
      display: block;
      color: #555;
    }

    .layui-input {
      width: 100%;
      height: 42px;
      border-radius: 12px;
      padding: 0 12px;
    }

    .show-password {
      position: absolute;
      right: 12px;
      top: 34px;
      cursor: pointer;
      font-size: 16px;
      color: #aaa;
    }

    .submit-btn {
      background-color: var(--button);
      color: #000000;
      width: 100%;
      padding: 12px;
      border: none;
      border-radius: 50px;
      font-weight: bold;
      margin-top: 12px;
      font-size: 16px;
      cursor: pointer;
      transition: background 0.2s ease;
    }

    .submit-btn:hover {
      background-color: #8fb01a;
    }
  
  .layui-input:focus {
      border-color: var(--primary) !important;
  }
  </style>
</head>
<body>

  <div class="container">
 <div class="logo">
      <img src="static/img/aicash222.png" alt="Logo" />
    </div>

    <div class="tab-switch">
      <div onclick="location.href='/register'">Register</div>
      <div class="active">Login</div>
    </div>

    <div class="form-title">Login</div>

    <form id="loginForm" class="layui-form" method="POST" action="<?php echo e(url('login')); ?>">
      <?php echo csrf_field(); ?>
      <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <div class="input-group">
        <label class="input-label">Mobile phone number</label>
        <input type="tel" name="phone" placeholder="Please enter your phone" class="layui-input" required />
      </div>

      <div class="input-group">
        <label class="input-label">Password</label>
        <input type="password" name="password" id="passwordInput" placeholder="Please enter password" class="layui-input" required />
        <span class="show-password" onclick="togglePassword()">👁️</span>
      </div>

      <button type="submit" class="submit-btn">Login Now</button>

      <p style="width: 100%; text-align: center; margin-top: 20px;">Forget Password <a href="<?php echo e(route('user.forget.password')); ?>" style="color: #004831">Click</a></p>
    </form>
  </div>

  <script>
    function togglePassword() {
      const input = document.getElementById('passwordInput');
      input.type = input.type === 'password' ? 'text' : 'password';
    }
  </script>

</body>
</html>
<?php /**PATH /home/orbiywol/lcfworld.com/resources/views/app/auth/login.blade.php ENDPATH**/ ?>