<?php $__env->startSection('admin_content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Job Positions</h4>
                    <a href="<?php echo e(route('admin.job.create')); ?>" class="btn btn-primary">Add New Position</a>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Order</th>
                                        <th>Title</th>
                                        <th>Salary</th>
                                        <th>Req. Level A</th>
                                        <th>Req. ABC</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $positions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php if($key > 0): ?>
                                                    <a href="<?php echo e(route('admin.job.moveUp', $position->id)); ?>" class="btn btn-sm btn-outline-primary" title="Move Up">
                                                        <i class="bx bx-up-arrow-alt"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if($key < count($positions) - 1): ?>
                                                    <a href="<?php echo e(route('admin.job.moveDown', $position->id)); ?>" class="btn btn-sm btn-outline-primary" title="Move Down">
                                                        <i class="bx bx-down-arrow-alt"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($position->title); ?></td>
                                            <td><?php echo e($position->salary); ?></td>
                                            <td><?php echo e($position->require_l1); ?></td>
                                            <td><?php echo e($position->require_abc); ?></td>
                                            <td>
                                                <span class="badge badge-light-<?php echo e($position->status == 'active' ? 'success' : 'danger'); ?>">
                                                    <?php echo e(ucfirst($position->status)); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('admin.job.edit', $position->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                                                <form action="<?php echo e(route('admin.job.destroy', $position->id)); ?>" method="POST" style="display:inline-block;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/orbiywol/lcfworld.com/resources/views/admin/pages/job/index.blade.php ENDPATH**/ ?>