<?php $__env->startSection('admin_content'); ?>
<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-12">
            <form action="<?php echo e(route('admin.package.insert')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" value="<?php echo e($data?->id); ?>">

                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-flex justify-content-between">
                            <div><?php echo e($data ? 'Update' : 'Create New'); ?> Package</div>
                            <div>
                                <a href="<?php echo e(route('admin.package.index')); ?>" class="btn btn-primary btn-sm">
                                    <i class="bx bx-left-arrow"></i> Package List
                                </a>
                            </div>
                        </h4>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            <?php $__currentLoopData = [
                                'name' => 'Package Name',
                                'title' => 'Package Title'
                            ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-sm-6">
                                <label for="<?php echo e($field); ?>"><?php echo e($label); ?></label>
                                <input type="text" class="form-control" name="<?php echo e($field); ?>" id="<?php echo e($field); ?>"
                                    value="<?php echo e($data?->$field); ?>" required>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <div class="col-sm-6">
                                <label for="price">Price</label>
                                <input type="number" class="form-control" name="price" id="price"
                                    value="<?php echo e($data?->price); ?>" required>
                            </div>

                            <div class="col-sm-6">
                                <label for="validity">Validity Days</label>
                                <input type="number" class="form-control" name="validity" id="validity"
                                    value="<?php echo e($data?->validity); ?>" required>
                            </div>

                            <div class="col-sm-6">
                                <label for="commission_with_avg_amount">Commission With Avg Amount</label>
                                <input type="number" class="form-control" name="commission_with_avg_amount"
                                    id="commission_with_avg_amount"
                                    value="<?php echo e($data?->commission_with_avg_amount); ?>" required>
                            </div>

                            <div class="col-sm-6">
                                <label for="discount_percentage">Discount %</label>
                                <input type="number" step="0.01" class="form-control" name="discount_percentage"
                                    id="discount_percentage" value="<?php echo e($data?->discount_percentage); ?>">
                            </div>

                            <div class="col-sm-6">
                                <label for="discounted_price">Discounted Price</label>
                                <input type="number" class="form-control" name="discounted_price"
                                    id="discounted_price" value="<?php echo e($data?->discounted_price); ?>">
                            </div>

                            <div class="col-sm-6">
                                <label for="buy_limit">Buy Limit</label>
                                <input type="number" class="form-control" name="buy_limit" id="buy_limit"
                                    value="<?php echo e($data?->buy_limit); ?>">
                            </div>

                            <div class="col-sm-6">
                                <label for="type">Package Type</label>
                                <select name="type" class="form-control" id="type" required>
                                    <?php $__currentLoopData = ['fixed', 'welfare', 'activity']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type); ?>"
                                            <?php if($data && $data->type === $type): ?> selected <?php endif; ?>><?php echo e(ucfirst($type)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-sm-6">
                                <label for="capital_back">Capital Return?</label>
                                <select name="capital_back" class="form-control" id="capital_back">
                                    <option value="0" <?php if($data && !$data->capital_back): ?> selected <?php endif; ?>>No</option>
                                    <option value="1" <?php if($data && $data->capital_back): ?> selected <?php endif; ?>>Yes</option>
                                </select>
                            </div>

                            <div class="col-sm-6">
                                <label for="is_sold_out">Sold Out</label>
                                <select name="is_sold_out" class="form-control" id="is_sold_out">
                                    <option value="0" <?php if($data && !$data->is_sold_out): ?> selected <?php endif; ?>>No</option>
                                    <option value="1" <?php if($data && $data->is_sold_out): ?> selected <?php endif; ?>>Yes</option>
                                </select>
                            </div>

                            <div class="col-sm-6">
                                <label for="show_timer">Show Countdown Timer</label>
                                <select name="show_timer" class="form-control" id="show_timer">
                                    <option value="0" <?php if($data && !$data->show_timer): ?> selected <?php endif; ?>>No</option>
                                    <option value="1" <?php if($data && $data->show_timer): ?> selected <?php endif; ?>>Yes</option>
                                </select>
                            </div>

                            <div class="col-sm-6">
                                <label for="is_default">Is Default</label>
                                <select name="is_default" class="form-control" id="is_default">
                                    <option value="0" <?php if($data && $data->is_default == '0'): ?> selected <?php endif; ?>>No</option>
                                    <option value="1" <?php if($data && $data->is_default == '1'): ?> selected <?php endif; ?>>Yes</option>
                                </select>
                            </div>

                            <div class="col-sm-6">
                                <label for="status">Status</label>
                                <select name="status" class="form-control" id="status" required>
                                    <option value="active" <?php if($data && $data->status === 'active'): ?> selected <?php endif; ?>>Active</option>
                                    <option value="inactive" <?php if($data && $data->status === 'inactive'): ?> selected <?php endif; ?>>Inactive</option>
                                </select>
                            </div>

                            <div class="col-sm-12">
                                <label for="desc">Package Description</label>
                                <textarea name="desc" class="form-control" rows="4"><?php echo e($data?->desc); ?></textarea>
                            </div>

                            <div class="col-sm-6">
                                <label for="required_direct_referrals">Required Direct Referrals for Purchase</label>
                                <input type="number" class="form-control" name="required_direct_referrals"
                                    id="required_direct_referrals" value="<?php echo e($data?->required_direct_referrals ?? 0); ?>">
                                <small class="text-muted">Minimum active direct referrals needed to buy this package.</small>
                            </div>

                            <div class="col-sm-12 mt-3">
                                <label>VIP Commission (Daily Profit based on Referrals)</label>
                                <div id="vip-commission-wrapper">
                                    <?php
                                        $vipCommissions = $data && $data->vip_commission ? json_decode($data->vip_commission, true) : [];
                                    ?>
                                    
                                    <?php if(count($vipCommissions) > 0): ?>
                                        <?php $__currentLoopData = $vipCommissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $vc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="row mb-2 vip-row">
                                                <div class="col-5">
                                                    <input type="number" name="vip_commission[<?php echo e($index); ?>][referrals]" class="form-control" placeholder="Referrals Count" value="<?php echo e($vc['referrals']); ?>" required>
                                                </div>
                                                <div class="col-5">
                                                    <input type="number" step="0.01" name="vip_commission[<?php echo e($index); ?>][income]" class="form-control" placeholder="Daily Income" value="<?php echo e($vc['income']); ?>" required>
                                                </div>
                                                <div class="col-2">
                                                    <button type="button" class="btn btn-danger remove-vip-row">X</button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                                <button type="button" class="btn btn-primary btn-sm mt-2" id="add-vip-row">+ Add VIP Tier</button>
                            </div>

                            <div class="col-sm-12 mt-2">
                                <div class="row">
                                    <div class="col-12 col-sm-6">
                                        <label for="photo">Upload Photo <small>(200x200)</small></label>
                                        <div class="custom-file">
                                            <input type="file" name="photo" class="custom-file-input"
                                                id="inputGroupFile01" onchange="showPreview(event)">
                                            <label class="custom-file-label" for="inputGroupFile01">Choose file</label>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 mt-1">
                                        <div class="image_preview">
                                            <img src="<?php echo e($data ? asset(view_image($data->photo)) : asset(not_found_img())); ?>"
                                                id="file-ip-1-preview" class="rounded"
                                                style="width: 100px; height: 100px;" alt="Preview Image">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Submit -->
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h6>Submit Package Information</h6>
                        <button type="submit" class="btn btn-success">
                            <i class="bx bx-save"></i> <?php echo e($data ? 'Update' : 'Submit'); ?>

                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<script>
    function showPreview(event){
        if(event.target.files.length > 0){
            var src = URL.createObjectURL(event.target.files[0]);
            document.getElementById("file-ip-1-preview").src = src;
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        const wrapper = document.getElementById('vip-commission-wrapper');
        const addBtn = document.getElementById('add-vip-row');
        let rowCount = <?php echo e($data && $data->vip_commission ? count(json_decode($data->vip_commission, true)) : 0); ?>;

        addBtn.addEventListener('click', function() {
            const div = document.createElement('div');
            div.className = 'row mb-2 vip-row';
            div.innerHTML = `
                <div class="col-5">
                    <input type="number" name="vip_commission[${rowCount}][referrals]" class="form-control" placeholder="Referrals Count" required>
                </div>
                <div class="col-5">
                    <input type="number" step="0.01" name="vip_commission[${rowCount}][income]" class="form-control" placeholder="Daily Income" required>
                </div>
                <div class="col-2">
                    <button type="button" class="btn btn-danger remove-vip-row">X</button>
                </div>
            `;
            wrapper.appendChild(div);
            rowCount++;
        });

        wrapper.addEventListener('click', function(e) {
            if (e.target.classList.contains('remove-vip-row')) {
                e.target.closest('.vip-row').remove();
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/orbiywol/lcfworld.com/resources/views/admin/pages/package/insert.blade.php ENDPATH**/ ?>