<style>
    .footer_menu {
      position: fixed;
      z-index: 9999;
      bottom: 0;
      left: 0;
      right: 0;
      border-radius: 120px 120px 0 0;
      margin: 0;
      padding: 0;
    }

    .footer_menu .content {
      background: #fff;
      display: flex;
      width: 100%;
      color: #A1BFF6;
    }

    .footer_menu .item {
      flex: 1;
      text-align: center;
      padding: 10px 0;
      transition: background-color 0.3s ease;
      background: transparent !important;
    }

    .footer_menu .item.active {
      background: transparent !important;
    }

    .footer_menu .item img {
      position: relative;
      width: 21px;
      height: 21px;
      transition: all 0.3s ease;
      filter: grayscale(100%);
    }

    .footer_menu .item p {
      margin-top: 4px;
      font-family: Arial, sans-serif;
      font-size: 14px;
      color: #AFAFAF;
      line-height: 20px;
      transition: color 0.3s ease;
    }

    .footer_menu .active p {
      color: #004831;
    }

    .footer_menu .active img {
      filter: grayscale(0%);
      mix-blend-mode: multiply;
      background-color: #004831; /* Green overlay */
      border-radius: 50%;
      padding: 2px; /* Optional: some spacing around icon */
    }
    
    .item {
  text-decoration: none;
}
    
    
  </style>

  <!-- Footer Section -->
  <div class="footer_menu">
    <div class="content">
      <a href="/home" class="item" id="home-link">
        <img src="<?php echo e(asset('/public/site/img/footer/home1.png')); ?>" alt="Home">
        <p>Home</p>
      </a>
      <a href="/products" class="item" id="product-link">
        <img src="<?php echo e(asset('/public/site/img/footer/product3.png')); ?>" alt="Products">
        <p>Products</p>
      </a>
      <a href="/my-team" class="item" id="notice-link">
        <img src="<?php echo e(asset('/public/site/img/footer/team.png')); ?>" alt="Team">
        <p>Team</p>
      </a>


      <a href="/profile" class="item" id="account-link">
        <img src="<?php echo e(asset('/public/site/img/footer/mine.png')); ?>" alt="Mine">
        <p>Account</p>
      </a>
    </div>
  </div>

  <script>
    const currentPath = window.location.pathname;
    const footerItems = document.querySelectorAll('.footer_menu .item');

    footerItems.forEach(item => item.classList.remove('active'));

    if (currentPath.startsWith('/home')) {
      document.getElementById('home-link').classList.add('active');
    } else if (currentPath.startsWith('/products')) {
      document.getElementById('product-link').classList.add('active');
    } else if (currentPath.startsWith('/my-team')) {
      document.getElementById('notice-link').classList.add('active');
    } else if (currentPath.startsWith('/community')) {
      document.getElementById('community-link').classList.add('active');
    } else if (currentPath.startsWith('/profile')) {
      document.getElementById('account-link').classList.add('active');
    }

    footerItems.forEach(item => {
      item.addEventListener('click', () => {
        footerItems.forEach(i => i.classList.remove('active'));
        item.classList.add('active');
      });
    });
  </script><?php /**PATH /home/orbiywol/lcfworld.com/resources/views/app/layout/manu.blade.php ENDPATH**/ ?>