<?php $__env->startSection('admin_content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Job Applications</h4>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>User</th>
                                        <th>Position</th>
                                        <th>Status</th>
                                        <th>Applied At</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($app->user->username); ?> (<?php echo e($app->user->name); ?>)</td>
                                            <td><?php echo e($app->position->title); ?></td>
                                            <td>
                                                <span class="badge badge-light-<?php echo e($app->status == 'approved' || $app->status == 'salary_paid' ? 'success' : ($app->status == 'pending' ? 'warning' : 'danger')); ?>">
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $app->status))); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e($app->created_at->format('d M Y')); ?></td>
                                            <td>
                                                <?php if($app->status == 'pending'): ?>
                                                    <a href="<?php echo e(route('admin.job.application.approve', $app->id)); ?>" class="btn btn-sm btn-success">Approve</a>
                                                    <a href="<?php echo e(route('admin.job.application.reject', $app->id)); ?>" class="btn btn-sm btn-danger">Reject</a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-2">
                            <?php echo e($applications->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/orbiywol/lcfworld.com/resources/views/admin/pages/job/applications.blade.php ENDPATH**/ ?>